/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.polling;

import com.atlassian.confluence.mail.ConfluencePopMailServer;
import com.atlassian.confluence.plugins.emailgateway.polling.AutoResponseMessageFilter;
import com.atlassian.confluence.plugins.emailgateway.polling.DeletedMessageFilter;
import com.atlassian.confluence.plugins.emailgateway.polling.MessageRecipientFilter;
import com.atlassian.confluence.plugins.emailgateway.polling.MessageSizeFilter;
import com.atlassian.confluence.plugins.emailgateway.polling.MimeMessageFilterFactory;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.mail.server.MailServerManager;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.mail.internet.MimeMessage;

public class DefaultMimeMessageFilterFactory
implements MimeMessageFilterFactory {
    private final SettingsManager settingsManager;
    private final MailServerManager mailServerManager;

    public DefaultMimeMessageFilterFactory(SettingsManager settingsManager, MailServerManager mailServerManager) {
        this.settingsManager = settingsManager;
        this.mailServerManager = mailServerManager;
    }

    @Override
    public Predicate<MimeMessage> getFilter() {
        ConfluencePopMailServer popMailServer = (ConfluencePopMailServer)this.mailServerManager.getDefaultPopMailServer();
        return Predicates.and((Predicate[])new Predicate[]{new DeletedMessageFilter(), new MessageRecipientFilter(popMailServer), new AutoResponseMessageFilter(), new MessageSizeFilter(this.settingsManager)});
    }
}

