/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.polling;

import com.atlassian.confluence.plugins.emailgateway.api.ReceivedEmail;
import com.atlassian.confluence.plugins.emailgateway.polling.EmailPoller;
import com.atlassian.confluence.plugins.emailgateway.polling.EmailPollingException;
import com.atlassian.confluence.plugins.emailgateway.polling.FolderUtils;
import com.atlassian.confluence.plugins.emailgateway.polling.MimeMessageFilterFactory;
import com.atlassian.confluence.plugins.emailgateway.polling.MimeMessageTransformer;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.PopMailServer;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import javax.naming.NamingException;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmailPoller
implements EmailPoller {
    private static final Logger log = LoggerFactory.getLogger(DefaultEmailPoller.class);
    private int batchSize = 10;
    private final MailServerManager mailServerManager;
    private final MimeMessageTransformer mimeMessageTransformer;
    private final MimeMessageFilterFactory mimeMessageFilterFactory;

    DefaultEmailPoller(MailServerManager mailServerManager, MimeMessageTransformer mimeMessageTransformer, MimeMessageFilterFactory mimeMessageFilterFactory) {
        this.mailServerManager = mailServerManager;
        this.mimeMessageTransformer = mimeMessageTransformer;
        this.mimeMessageFilterFactory = mimeMessageFilterFactory;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public boolean isAvailable() {
        return this.getMailServer() != null;
    }

    @Override
    public Collection<ReceivedEmail> pollForIncomingEmails() throws EmailPollingException {
        try {
            PopMailServer mailServer = this.getMailServer();
            if (mailServer == null) {
                throw new EmailPollingException("No mail server configured");
            }
            return FolderUtils.execute(this.getWorker((MailServer)mailServer));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException && e.getCause().getMessage().contains("Connection refused")) {
                log.debug("Can't open mail server folder: " + e.getMessage());
                return Lists.newArrayList();
            }
            Throwables.propagateIfPossible((Throwable)e);
            throw new EmailPollingException("Failed to interrogate mail folder", e);
        }
    }

    private FolderUtils.FolderWorker<Collection<ReceivedEmail>> getWorker(final MailServer mailServer) {
        return new FolderUtils.FolderWorker<Collection<ReceivedEmail>>(){

            @Override
            public Folder openFolder(Store store) throws MessagingException {
                Folder folder = store.getFolder("INBOX");
                folder.open(2);
                return folder;
            }

            @Override
            public Collection<ReceivedEmail> doWithFolder(Folder folder) throws MessagingException {
                List messages = DefaultEmailPoller.this.getNextMessageBatch(folder);
                return DefaultEmailPoller.this.convertMessages(messages, mailServer);
            }

            @Override
            public Session getMailSession() throws MailException {
                return DefaultEmailPoller.getSession(mailServer);
            }
        };
    }

    private static Session getSession(MailServer mailServer) throws MailException {
        try {
            return mailServer.getSession();
        }
        catch (NamingException e) {
            throw new MailException((Throwable)e);
        }
    }

    private PopMailServer getMailServer() {
        return this.mailServerManager.getDefaultPopMailServer();
    }

    private List<Message> getNextMessageBatch(Folder folder) throws MessagingException {
        int messageCount = folder.getMessageCount();
        if (messageCount == 0) {
            return Collections.emptyList();
        }
        log.debug("There are {} messages in folder {}", (Object)messageCount, (Object)folder.getName());
        return Arrays.asList(folder.getMessages(1, Math.min(this.batchSize, messageCount)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ReceivedEmail> convertMessages(Collection<? extends Message> mimeMessages, MailServer mailServer) {
        ArrayList receivedEmails = Lists.newArrayList();
        if (mimeMessages.size() == 0) {
            return receivedEmails;
        }
        Predicate<MimeMessage> mimeMessageFilter = this.mimeMessageFilterFactory.getFilter();
        for (Message message : mimeMessages) {
            MimeMessage mimeMessage = (MimeMessage)message;
            String messageId = DefaultEmailPoller.getMessageId(mimeMessage);
            try {
                if (mimeMessageFilter.apply((Object)mimeMessage)) {
                    receivedEmails.add(this.mimeMessageTransformer.transformMimeMessage(mimeMessage, mailServer));
                    continue;
                }
                log.warn("Message {} has been rejected by the filter; skipping it", (Object)messageId);
            }
            catch (Exception ex) {
                log.warn("Failed to process inbound MimeMessage " + messageId, (Throwable)ex);
            }
            finally {
                DefaultEmailPoller.deleteMessageFromServer(mimeMessage, messageId);
            }
        }
        return receivedEmails;
    }

    private static String getMessageId(MimeMessage message) {
        try {
            return message.getMessageID();
        }
        catch (MessagingException ex) {
            String randomId = "Random-" + RandomStringUtils.random((int)10);
            log.error("Could not extract messageID from message, using temporary ID " + randomId);
            return randomId;
        }
    }

    private static void deleteMessageFromServer(MimeMessage mimeMessage, String messageID) {
        try {
            mimeMessage.setFlag(Flags.Flag.DELETED, true);
        }
        catch (MessagingException e) {
            log.error("Could not delete email with messageId [{}]. Please delete this message manually, as too many undeleted messages will slow down Confluence", (Object)messageID);
        }
    }
}

