/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ooxml.util;

import javax.xml.transform.TransformerFactory;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class TransformerHelper {
    private static POILogger logger = POILogFactory.getLogger(TransformerHelper.class);
    static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    private TransformerHelper() {
    }

    public static TransformerFactory getFactory() {
        return transformerFactory;
    }

    private static void trySetFeature(TransformerFactory tf, String feature, boolean enabled) {
        try {
            tf.setFeature(feature, enabled);
        }
        catch (Exception e) {
            logger.log(5, "TransformerFactory Feature unsupported", feature, e);
        }
        catch (AbstractMethodError ame) {
            logger.log(5, "Cannot set TransformerFactory feature because outdated XML parser in classpath", feature, ame);
        }
    }

    static {
        TransformerHelper.trySetFeature(transformerFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
    }
}

