/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl.runnable.cloud;

import com.atlassian.confluence.plugins.conversion.impl.runnable.cloud.HttpMethod;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class CloudRequest<T> {
    private final CloseableHttpClient client;
    private final HttpUriRequest request;
    private final ResponseHandler<T> responseHandler;
    private final String requestName;

    CloudRequest(CloseableHttpClient client, HttpMethod httpMethod, String url, @Nullable String authorisationToken, ResponseHandler<T> responseHandler, String requestName, List<Header> headers, @Nullable HttpEntity entity) {
        this.client = client;
        switch (httpMethod) {
            case GET: {
                this.request = new HttpGet(url);
                break;
            }
            case HEAD: {
                this.request = new HttpHead(url);
                break;
            }
            case POST: {
                this.request = new HttpPost(url);
                break;
            }
            case PUT: {
                this.request = new HttpPut(url);
                break;
            }
            case DELETE: {
                this.request = new HttpDelete(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled HTTP method " + (Object)((Object)httpMethod));
            }
        }
        if (authorisationToken != null) {
            this.request.setHeader("Authorization", "Vendor " + authorisationToken);
        }
        if (!headers.isEmpty()) {
            for (Header header : headers) {
                this.request.addHeader(header);
            }
        }
        if (entity != null) {
            if (!(this.request instanceof HttpEntityEnclosingRequest)) {
                throw new IllegalArgumentException("HTTP method " + (Object)((Object)httpMethod) + " does not allow a body to be set");
            }
            HttpEntityEnclosingRequest requestWithBody = (HttpEntityEnclosingRequest)this.request;
            requestWithBody.setEntity(entity);
        }
        this.responseHandler = responseHandler;
        this.requestName = requestName;
    }

    public T execute() throws IOException {
        try {
            if (this.responseHandler == null) {
                this.client.execute(this.request);
                return null;
            }
            return (T)this.client.execute(this.request, this.responseHandler);
        }
        catch (IOException e) {
            throw new IOException("Request " + this.requestName + " (" + this.request.getMethod() + " " + this.request.getURI() + ") failed due to an I/O error: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }
}

