/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.persistence.dao.filesystem.filestore.FileStoreClientIdentitySupplier;
import com.atlassian.confluence.pages.persistence.dao.filesystem.filestore.FileStoreClientSupplier;
import com.atlassian.confluence.plugins.conversion.api.ConversionResult;
import com.atlassian.confluence.plugins.conversion.api.ConversionResultSupplier;
import com.atlassian.confluence.plugins.conversion.api.ConversionType;
import com.atlassian.confluence.plugins.conversion.api.FileStoreConversionResult;
import com.atlassian.confluence.plugins.conversion.impl.FileStoreMode;
import com.atlassian.filestore.client.api.FileStoreClient;
import com.atlassian.filestore.client.api.entity.ClientIdentity;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="fileStoreConversionResultSupplier")
public class FileStoreConversionResultSupplier
extends ConversionResultSupplier {
    private FileStoreClientSupplier fileStoreClientSupplier = null;
    private FileStoreClientIdentitySupplier fileStoreClientIdentitySupplier = null;

    @Autowired
    public FileStoreConversionResultSupplier(@ComponentImport FileStoreClientSupplier fileStoreClientSupplier, @ComponentImport FileStoreClientIdentitySupplier fileStoreClientIdentitySupplier) {
        if (FileStoreMode.isFileStoreActive()) {
            this.fileStoreClientSupplier = Objects.requireNonNull(fileStoreClientSupplier);
            this.fileStoreClientIdentitySupplier = Objects.requireNonNull(fileStoreClientIdentitySupplier);
        }
    }

    @Override
    public ConversionResult getConversionResult(Attachment attachment, ConversionType conversionType) {
        if (!FileStoreMode.isFileStoreActive()) {
            throw new RuntimeException("FileStoreConversionResultSupplier cannot be used when filestore is not active.");
        }
        return new FileStoreConversionResult((FileStoreClient)this.fileStoreClientSupplier.get(), (ClientIdentity)this.fileStoreClientIdentitySupplier.get(), attachment, conversionType, this.conversionManager.getConversionUrl(attachment.getId(), attachment.getVersion(), conversionType));
    }
}

