/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.api;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.persistence.dao.filesystem.filestore.GsonJsonableFactory;
import com.atlassian.confluence.plugins.conversion.api.ConversionData;
import com.atlassian.confluence.util.logging.LoggingContext;
import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.output.CountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingConversionData
implements ConversionData {
    private static final Logger log = LoggerFactory.getLogger(TrackingConversionData.class);
    private final GsonJsonableFactory jsonableFactory = new GsonJsonableFactory(GsonBuilder::excludeFieldsWithoutExposeAnnotation);
    private final Attachment attachment;
    private final ConversionData delegate;
    private final String delegateName;

    public TrackingConversionData(Attachment attachment, String delegateName, ConversionData delegate) {
        this.delegateName = delegateName;
        this.delegate = delegate;
        this.attachment = attachment;
    }

    @Override
    public StreamingOutput getStreamingOutput() {
        return outputStream -> {
            final Event event = new Event(this.attachment.getFileStoreId(), this.attachment.getId());
            CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream){

                public void close() throws IOException {
                    super.close();
                    event.setFileSize(this.getByteCount());
                    event.send();
                }
            };
            this.delegate.getStreamingOutput().write((OutputStream)countingOutputStream);
        };
    }

    @Override
    public long getContentLength() {
        return this.delegate.getContentLength();
    }

    @Override
    public Optional<String> getContentRange() {
        return this.delegate.getContentRange();
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    class Event<T> {
        @Expose
        private final String implementation;
        @Expose
        private long duration;
        @Expose
        private long fileSize;
        @Expose
        private long transferRate;
        @Expose
        private final String fileStoreId;
        @Expose
        private final long attachmentId;
        private Throwable e;
        private final long startTime;

        public Event(String fileStoreId, long attachmentId) {
            this.implementation = TrackingConversionData.this.delegateName;
            this.startTime = System.currentTimeMillis();
            this.fileStoreId = fileStoreId;
            this.attachmentId = attachmentId;
        }

        public Event<T> setFileSize(long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public void send() {
            this.duration = System.currentTimeMillis() - this.startTime;
            this.transferRate = this.duration == 0L ? 0L : this.fileSize / this.duration;
            LoggingContext.executeWithContext((Map)ImmutableMap.of((Object)"fileConversionDownloadEvent", (Object)TrackingConversionData.this.jsonableFactory.apply((Object)this)), () -> log.info("Published a fileConversionDownloadEvent", this.e));
        }
    }
}

