/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.action;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugins.conversion.impl.ConfigurationProperties;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.user.User;

public class AdminPageAction
extends ConfluenceActionSupport {
    private String cloudUrl;
    private int threadCount;
    private BandanaManager bandanaManager;
    static final BandanaContext ADMIN_PAGE_DATA_CONTEXT = new ConfluenceBandanaContext(AdminPageAction.class.getName());

    public boolean isPermitted() {
        if (this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM)) {
            String bandanaUrl = (String)this.bandanaManager.getValue(ADMIN_PAGE_DATA_CONTEXT, ConfigurationProperties.PROP_CLOUD_URL.toString());
            String bandanaTCount = (String)this.bandanaManager.getValue(ADMIN_PAGE_DATA_CONTEXT, ConfigurationProperties.PROP_NUM_THREADS.toString());
            if (bandanaUrl != null) {
                System.setProperty(ConfigurationProperties.PROP_CLOUD_URL.toString(), bandanaUrl);
            }
            if (bandanaTCount != null) {
                System.setProperty(ConfigurationProperties.PROP_NUM_THREADS.toString(), bandanaTCount);
            }
            this.cloudUrl = ConfigurationProperties.getString(ConfigurationProperties.PROP_CLOUD_URL);
            this.threadCount = ConfigurationProperties.getInt(ConfigurationProperties.PROP_NUM_THREADS);
            return true;
        }
        return false;
    }

    public void setThreadCount(int count) {
        System.setProperty(ConfigurationProperties.PROP_NUM_THREADS.toString(), Integer.toString(count));
        this.threadCount = count;
        this.bandanaManager.setValue(ADMIN_PAGE_DATA_CONTEXT, ConfigurationProperties.PROP_NUM_THREADS.toString(), (Object)Integer.toString(this.threadCount));
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setCloudUrl(String url) {
        System.setProperty(ConfigurationProperties.PROP_CLOUD_URL.toString(), url);
        this.cloudUrl = url;
        this.bandanaManager.setValue(ADMIN_PAGE_DATA_CONTEXT, ConfigurationProperties.PROP_CLOUD_URL.toString(), (Object)this.cloudUrl);
    }

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }
}

