/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.upgrade;

import com.atlassian.confluence.plugins.conversion.impl.FileSystemConversionState;
import com.atlassian.confluence.setup.settings.ConfluenceFlavour;
import com.atlassian.confluence.setup.settings.ConfluenceFlavourService;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearCachedConversionErrors
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ClearCachedConversionErrors.class);
    private static final Pattern ERROR_FILE_PATTERN = Pattern.compile(".*\\.err");
    private static final FileFilter DIRECTORY_OR_ERROR_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            Matcher errorFileMatcher = ERROR_FILE_PATTERN.matcher(file.getAbsolutePath());
            return errorFileMatcher.matches();
        }
    };
    private final ConfluenceFlavourService confluenceFlavourService;

    public ClearCachedConversionErrors(ConfluenceFlavourService confluenceFlavourService) {
        this.confluenceFlavourService = confluenceFlavourService;
    }

    public String getShortDescription() {
        return "Deletes cached error results in the conversions cache";
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-document-conversion-library";
    }

    public Collection<Message> doUpgrade() throws Exception {
        if (!this.isOnDemand()) {
            log.debug("Not running in non-OnDemand configuration.");
            return Collections.emptyList();
        }
        long numDeletedFiles = 0L;
        Collection<File> conversionDirectories = FileSystemConversionState.getConversionDirectories();
        for (File conversionDirectory : conversionDirectories) {
            if (!conversionDirectory.exists() || !conversionDirectory.isDirectory()) continue;
            numDeletedFiles += this.deleteErrorFilesInDirectory(conversionDirectory);
        }
        log.info("Deleted {} cached conversion error files.", (Object)numDeletedFiles);
        return Collections.emptyList();
    }

    private boolean isOnDemand() {
        Option aLaCarteOption = Option.some((Object)ConfluenceFlavour.ALACARTE);
        Option standaloneOption = Option.some((Object)ConfluenceFlavour.STANDALONE);
        return this.confluenceFlavourService.isCurrentFlavourEqualTo(aLaCarteOption) || this.confluenceFlavourService.isCurrentFlavourEqualTo(standaloneOption);
    }

    private long deleteErrorFilesInDirectory(File directory) {
        File[] matchedFiles;
        long numDeletedFiles = 0L;
        String dirAbsolutePath = directory.getAbsolutePath();
        log.debug("Iterating files in {}", (Object)dirAbsolutePath);
        for (File matchedFile : matchedFiles = directory.listFiles(DIRECTORY_OR_ERROR_FILE_FILTER)) {
            String matchedFileAbsolutePath = matchedFile.getAbsolutePath();
            log.debug("Matched file: {}", (Object)matchedFileAbsolutePath);
            if (matchedFile.isDirectory()) {
                numDeletedFiles += this.deleteErrorFilesInDirectory(matchedFile);
                continue;
            }
            if (!this.deleteFile(matchedFile)) continue;
            ++numDeletedFiles;
        }
        log.debug("Finished iterating files in {}", (Object)dirAbsolutePath);
        return numDeletedFiles;
    }

    private boolean deleteFile(File matchedFile) {
        String matchedFileAbsolutePath = matchedFile.getAbsolutePath();
        try {
            if (matchedFile.delete()) {
                log.info("Deleted conversion result file {}", (Object)matchedFileAbsolutePath);
                return true;
            }
            log.warn("Failed to delete file {}", (Object)matchedFileAbsolutePath);
        }
        catch (SecurityException e) {
            log.warn("Failed to delete file due to security exception {}", (Object)matchedFileAbsolutePath, (Object)e);
        }
        return false;
    }
}

