/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.dom;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.conversion.dom.DefaultImportContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.Doc2Wiki;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.splitter.BookmarkInfo;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.splitter.DocumentTreeNode;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.splitter.SplitImportContext;
import com.google.common.base.Throwables;
import java.awt.Dimension;
import java.util.List;

public class DefaultSplitImportContext
extends DefaultImportContext
implements SplitImportContext {
    private static final int MAX_TITLE_LENGTH = 254;
    private List<DocumentTreeNode<Page>> _orderedNodes;
    private int _nodeIndex;
    private final int _splitLvl;
    private final ConfluenceUser _user;
    private int _lastLevel;
    private DocumentTreeNode<Page> _currentNode;

    public DefaultSplitImportContext(PageManager pageManager, Page page, Page oldPage, AttachmentManager attachmentManager, BookmarkInfo bookmarks, List<DocumentTreeNode<Page>> orderedNodes, int splitLvl, Dimension maxImportImageSize) {
        super(pageManager, (AbstractPage)page, (AbstractPage)oldPage, attachmentManager, bookmarks, maxImportImageSize);
        this._splitLvl = splitLvl;
        this._orderedNodes = orderedNodes;
        this._user = AuthenticatedUserThreadLocal.get();
    }

    public DocumentTreeNode<Page> getNextNode() {
        return this._orderedNodes.get(this._nodeIndex++);
    }

    public boolean splitPage(StringBuilder content, Doc2Wiki doc2wiki) {
        this._currentNode = this.getNextNode();
        int nodeLvl = this._currentNode.getLvl();
        if (nodeLvl > this._splitLvl) {
            return false;
        }
        doc2wiki.pageEnd();
        this.finish(content);
        Page newPage = null;
        this._oldPage = (AbstractPage)this._currentNode.getOldPage();
        if (this._oldPage != null) {
            try {
                newPage = (Page)this._oldPage;
                this._oldPage = (Page)newPage.clone();
                newPage.setTitle(this._currentNode.getText());
            }
            catch (Exception ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        } else {
            newPage = this.createNewPage(this._currentNode.getText());
        }
        while (nodeLvl <= this._lastLevel) {
            this._page = ((Page)this._page).getParent();
            --this._lastLevel;
        }
        this._lastLevel = nodeLvl;
        ((Page)this._page).addChild(newPage);
        this._page = newPage;
        return true;
    }

    public int getNodeLevel() {
        return this._currentNode.getLvl();
    }

    public int getSplitLevel() {
        return this._splitLvl;
    }

    @Override
    public String createHyperlinkReference(StringBuffer codeBuf) {
        String ref = this.parseFieldCode(codeBuf);
        if (ref != null && this._bookmarks.containsKey(ref)) {
            DocumentTreeNode originalNode;
            DocumentTreeNode node = originalNode = this._bookmarks.get(ref);
            while (node.getLvl() > this._splitLvl) {
                node = node.getParent();
            }
            ref = this._bookmarks.isInHeading(ref) && node == originalNode ? node.getText() : (node != this._currentNode && node.getLvl() != 0 ? node.getText() + '#' + ref : '#' + ref);
        }
        return ref;
    }

    private Page createNewPage(String text) {
        Page page = new Page();
        page.setTitle(text.substring(0, Math.min(text.length(), 254)));
        page.setSpace(this._page.getSpace());
        page.setCreator(this._user);
        return page;
    }
}

