package com.atlassian.confluence.plugins.createcontent.services;

import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreatePersonalSpaceRestEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageRequest;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintSpaceEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintSpaceRequest;
import com.atlassian.confluence.plugins.createcontent.services.model.CreatePersonalSpaceRequest;
import com.atlassian.confluence.user.ConfluenceUser;

/**
 * Resolves CreateBlueprint Request REST entities to Model objects. Richard A called this process rest mutation which
 * sounds awesome but probably isn't what this interface should be called.
 *
 * @since 2.0
 */
public interface RequestResolver {
    /**
     * Validates a create page Entity and resolves any Model keys into their respective objects (e.g. space key into Space).
     */
    CreateBlueprintPageRequest resolve(CreateBlueprintPageEntity entity, ConfluenceUser creator)
            throws BlueprintIllegalArgumentException;

    /**
     * Validates a create space Entity and resolves any Model keys into their respective objects.
     */
    CreateBlueprintSpaceRequest resolve(CreateBlueprintSpaceEntity entity, ConfluenceUser creator)
            throws BlueprintIllegalArgumentException;

    /**
     * Validates a create personal space Entity and resolves any Model keys into their respective objects.
     */
    CreatePersonalSpaceRequest resolve(CreatePersonalSpaceRestEntity entity, ConfluenceUser creator);
}
