package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.plugins.createcontent.SpaceBandanaContext;
import com.atlassian.confluence.plugins.createcontent.api.services.ContentBlueprintService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@Component
public class RemoveSpaceListener {
    private final BandanaManager bandanaManager;
    private final EventPublisher eventPublisher;
    private final ContentBlueprintService contentBlueprintService;

    @Autowired
    public RemoveSpaceListener(
            final @ComponentImport BandanaManager bandanaManager,
            final @ComponentImport EventPublisher eventPublisher,
            final ContentBlueprintService contentBlueprintService) {
        this.bandanaManager = bandanaManager;
        this.eventPublisher = eventPublisher;
        this.contentBlueprintService = contentBlueprintService;
    }

    @EventListener
    public void onSpaceRemoveEvent(SpaceRemoveEvent event) {
        Space deletedSpace = event.getSpace();
        SpaceBandanaContext spaceBandanaContext = new SpaceBandanaContext(deletedSpace);

        // remove all stored data for this space
        for (String key : bandanaManager.getKeys(spaceBandanaContext)) {
            bandanaManager.removeValue(spaceBandanaContext, key);
        }
        // remove all content blueprints for this space
        contentBlueprintService.deleteContentBlueprintsForSpace(deletedSpace.getKey());
    }

    @PreDestroy
    public void destroy() {
        eventPublisher.unregister(this);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        eventPublisher.register(this);
    }
}
