package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.confluence.plugins.createcontent.model.BlueprintState;
import com.atlassian.confluence.user.ConfluenceUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface SpaceBlueprintStateController {
    /**
     * Enable a space blueprint plugin by its id.
     *
     * @param blueprintId id of the blueprint to be enabled
     */
    void enableSpaceBlueprint(UUID blueprintId);

    /**
     * Disable a space blueprint plugin by its id.
     *
     * @param blueprintId id of the blueprint to be disabled
     */
    void disableSpaceBlueprint(UUID blueprintId);

    /**
     * Disable a set of space blueprint plugin ids.
     *
     * @param blueprintIds set of blueprint ids to be disabled
     */
    void disableSpaceBlueprints(Set<UUID> blueprintIds);

    /**
     * Returns a set of disabled space blueprints UUIDs.
     *
     * @return all keys of disabled space blueprint plugin modules, an empty set if none is found
     */
    Set<UUID> getDisabledSpaceBlueprintIds();

    /**
     * Returns a set of space disabled blueprints module complete keys.
     *
     * @return all keys of disabled plugin modules, an empty set if none is found
     */
    Set<String> getDisabledSpaceBlueprintModuleCompleteKeys();

    /**
     * Returns a set of space blueprint keys that are available to a user. If a blueprint is plugin backed,
     * it is only returned if its Condition evaluates to true and if the plugin module is enabled.
     *
     * @param user (optional) the user. null for anonymous
     * @return all the keys of blueprints that are available to a user in the space, an empty set if none is found
     * @since 2.1.16
     */
    Map<UUID, BlueprintState> getAllSpaceBlueprintState(@Nonnull String section, @Nullable ConfluenceUser user);
}
