package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.plugins.createcontent.impl.SpaceBlueprint;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.UUID;

@XmlRootElement
public class SpaceBlueprintEntity {
    @XmlElement
    private SpaceBlueprint spaceBlueprint;

    @XmlAttribute
    private UUID homePageId;

    @XmlAttribute
    private Long homePageTemplateId;

    // JAXB
    private SpaceBlueprintEntity() {
    }

    public SpaceBlueprintEntity(@Nonnull final SpaceBlueprint spaceBlueprint, @Nonnull final UUID homePageId) {
        this.spaceBlueprint = spaceBlueprint;
        this.homePageId = homePageId;
    }

    public SpaceBlueprintEntity(@Nonnull final SpaceBlueprint spaceBlueprint, final long homePageTemplateId) {
        this.spaceBlueprint = spaceBlueprint;
        this.homePageTemplateId = homePageTemplateId;
    }

    @Nonnull
    SpaceBlueprint getSpaceBlueprint() {
        return spaceBlueprint;
    }

    @Nullable
    UUID getHomePageId() {
        return homePageId;
    }

    @Nullable
    Long getHomePageTemplateId() {
        return homePageTemplateId;
    }
}
