package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.plugins.createcontent.services.RequestStorage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * @since 9.1.6
 */
@Component
public class PageCreateEventListener {
    private static final Logger log = LoggerFactory.getLogger(PageCreateEventListener.class);

    private final EventPublisher eventPublisher;
    private final RequestStorage requestStorage;

    @Autowired
    public PageCreateEventListener(
            final @ComponentImport EventPublisher eventPublisher,
            final RequestStorage requestStorage) {
        this.eventPublisher = eventPublisher;
        this.requestStorage = requestStorage;
    }

    @PreDestroy
    public void destroy() {
        eventPublisher.unregister(this);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        eventPublisher.register(this);
    }

    /**
     * Remove the "create.blueprint.page.draft.request" property from os_propertyentry for the published content.
     *
     * @param event the event fired when a draft is published.
     */
    @EventListener
    public void onPageCreateEvent(PageCreateEvent event) {
        log.debug("Draft with ID {} was published. Clearing any Create Request for it.", event.getPage().getId());
        requestStorage.clear(event.getContent());
    }
}
