package com.atlassian.confluence.plugins.createcontent.exceptions;

import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.RestTypedException;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractTypedRuntimeException extends RuntimeException implements RestTypedException {
    private final ResourceErrorType errorType;
    private final Object errorData;

    public AbstractTypedRuntimeException(@Nonnull final Throwable cause, @Nonnull final ResourceErrorType errorType) {
        this(cause, errorType, null);
    }

    public AbstractTypedRuntimeException(@Nonnull final Throwable cause, @Nonnull final ResourceErrorType errorType, @Nullable Object errorData) {
        super(cause);
        this.errorType = errorType;
        this.errorData = errorData;
    }

    public AbstractTypedRuntimeException(@Nonnull final String message, @Nonnull final ResourceErrorType errorType) {
        this(message, errorType, null);
    }

    public AbstractTypedRuntimeException(@Nonnull final String message, @Nonnull final ResourceErrorType errorType, @Nullable Object errorData) {
        super(message);
        this.errorType = errorType;
        this.errorData = errorData;
    }

    public AbstractTypedRuntimeException(@Nonnull final String message, @Nonnull final Throwable cause, @Nonnull final ResourceErrorType errorType) {
        this(message, cause, errorType, null);
    }

    public AbstractTypedRuntimeException(@Nonnull final String message, @Nonnull final Throwable cause, @Nonnull final ResourceErrorType errorType, @Nullable Object errorData) {
        super(message, cause);
        this.errorType = errorType;
        this.errorData = errorData;
    }

    @Override
    public ResourceErrorType getErrorType() {
        return errorType;
    }

    @Override
    public Object getErrorData() {
        return errorData;
    }
}
