package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.plugins.createcontent.impl.SpaceBlueprint;
import com.atlassian.confluence.plugins.createcontent.model.BlueprintState;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@Component
public class BandanaSpaceBlueprintStateController extends AbstractBandanaBlueprintStateController implements SpaceBlueprintStateController {
    private static final String DISABLED_SPACE_BLUEPRINT_ITEMS = "com.atlassian.confluence.space.blueprints.disabled";
    private SpaceBlueprintManager spaceBlueprintManager;

    @Autowired
    public BandanaSpaceBlueprintStateController(
            @ComponentImport BandanaManager bandanaManager,
            SpaceBlueprintManager spaceBlueprintManager,
            @ComponentImport WebInterfaceManager webInterfaceManager,
            @ComponentImport PluginAccessor pluginAccessor) {
        super(bandanaManager, webInterfaceManager, pluginAccessor);
        this.spaceBlueprintManager = spaceBlueprintManager;
    }

    @Override
    public void enableSpaceBlueprint(UUID blueprintId) {
        enableBlueprint(blueprintId, null, DISABLED_SPACE_BLUEPRINT_ITEMS);
    }

    @Override
    public void disableSpaceBlueprint(UUID blueprintId) {
        disableBlueprint(blueprintId, null, DISABLED_SPACE_BLUEPRINT_ITEMS);
    }

    @Override
    public void disableSpaceBlueprints(Set<UUID> blueprintIds) {
        disableBlueprints(blueprintIds, null, DISABLED_SPACE_BLUEPRINT_ITEMS);
    }

    @Override
    public Set<String> getDisabledSpaceBlueprintModuleCompleteKeys() {
        return getDisabledSpaceBlueprintModuleCompleteKeys(null, DISABLED_SPACE_BLUEPRINT_ITEMS, spaceBlueprintManager);
    }

    @Override
    public Map<UUID, BlueprintState> getAllSpaceBlueprintState(@Nonnull String section, @Nullable ConfluenceUser user) {
        List<SpaceBlueprint> blueprints = spaceBlueprintManager.getAll();
        Map<UUID, BlueprintState> blueprintStateMap = buildBlueprintStateMap(section, user, null, DISABLED_SPACE_BLUEPRINT_ITEMS, blueprints);
        return ImmutableMap.copyOf(blueprintStateMap);
    }

    @Override
    public Set<UUID> getDisabledSpaceBlueprintIds() {
        return getDisabledBlueprintIds(null, DISABLED_SPACE_BLUEPRINT_ITEMS);
    }
}
