package com.atlassian.confluence.plugins.createcontent.exceptions;

import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown when a blueprint module cannot be looked up in the plugin system because it is either not present or not
 * enabled.
 */
public class BlueprintPluginNotFoundException extends AbstractTypedRuntimeException {
    public BlueprintPluginNotFoundException(@Nonnull final String message, @Nonnull final ResourceErrorType errorType, @Nullable final Object errorData) {
        super(message, errorType, errorData);
    }
}
