package com.atlassian.confluence.plugins.createcontent.conditions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.PluginParseException;

import java.util.Map;

import static com.atlassian.confluence.plugins.createcontent.SpaceUtils.hasCreatePagePermission;
import static com.atlassian.confluence.plugins.createcontent.SpaceUtils.hasEditableSpaces;

/**
 * Condition that determines whether the user in the context has permission to create content.
 */
public class CreateContentCondition extends BaseConfluenceCondition {
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionManager;
    private String contentType;

    public CreateContentCondition(SpaceManager spaceManager, SpacePermissionManager spacePermissionManager) {
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
        contentType = params.get("contentType");
    }

    public boolean shouldDisplay(final WebInterfaceContext context) {
        if (contentType != null && contentType.equals("page")) // For Quick create business
        {
            return hasCreatePagePermission(context.getCurrentUser(), context.getSpace(), spaceManager, spacePermissionManager);
        }
        return hasEditableSpaces(context.getCurrentUser(), spaceManager);
    }

}