package com.atlassian.confluence.plugins.createcontent.api.contextproviders;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.confluence.plugins.createcontent.TemplateRendererHelper;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;

import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * Provides a {@link BlueprintContext} for Blueprint Template renders.
 * <p>
 * "context-provider" implementations in "content-template" plugin modules should extend this class rather than
 * implementing {@link ContextProvider} directly.
 */
@PublicSpi
public abstract class AbstractBlueprintContextProvider implements ContextProvider {
    protected TemplateRendererHelper templateRendererHelper;

    /**
     * @deprecated since 2.1.18.
     */
    @Deprecated
    public AbstractBlueprintContextProvider() {

    }

    public AbstractBlueprintContextProvider(TemplateRendererHelper templateRendererHelper) {
        this.templateRendererHelper = templateRendererHelper;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
    }

    @Override
    public final Map<String, Object> getContextMap(Map<String, Object> context) {
        return updateBlueprintContext(new BlueprintContext(context)).getMap();
    }

    /**
     * Updates the given {@link BlueprintContext} to include extra context required by a PageTemplate render.
     */
    protected abstract BlueprintContext updateBlueprintContext(BlueprintContext blueprintContext);

    protected String renderCreateFromTemplateMacro(String contentBlueprintId, String createButtonLabel, String spaceKey,
                                                   String blueprintModuleCompleteKey) {
        if (templateRendererHelper == null) {
            throw new UnsupportedOperationException("Cannot use this method without first specifying a templateRendererHelper.");
        }

        final Map<String, String> createFromTemplateMacroParams = newHashMap();

        createFromTemplateMacroParams.put("contentBlueprintId", contentBlueprintId);
        createFromTemplateMacroParams.put("createButtonLabel", createButtonLabel);
        if (isNotBlank(spaceKey))
            createFromTemplateMacroParams.put("spaceKey", spaceKey);
        createFromTemplateMacroParams.put("contentBlueprintId", contentBlueprintId);
        // We need to keep blueprintModuleCompleteKey as macro parameter
        // We use it when resolving which BP is to be applied (in case of customisations) when rendering the macro
        createFromTemplateMacroParams.put("blueprintModuleCompleteKey", blueprintModuleCompleteKey);

        return templateRendererHelper.renderMacroXhtml("create-from-template", createFromTemplateMacroParams);
    }

    protected String renderContentReportTableMacro(String templateLabel, String analyticsKey, String spaceKey, String blankTitle,
                                                   String blankDescription, String createButtonLabel, String contentBlueprintId, String blueprintModuleCompleteKey) {
        if (templateRendererHelper == null) {
            throw new UnsupportedOperationException("Cannot use this method without first specifying a templateRendererHelper.");
        }

        final Map<String, String> contentReportTableMacroParams = newHashMap();
        contentReportTableMacroParams.put("labels", templateLabel);
        contentReportTableMacroParams.put("analyticsKey", analyticsKey);
        contentReportTableMacroParams.put("spaces", spaceKey);
        contentReportTableMacroParams.put("blankTitle", blankTitle);
        contentReportTableMacroParams.put("blankDescription", blankDescription);
        contentReportTableMacroParams.put("createButtonLabel", createButtonLabel);
        contentReportTableMacroParams.put("contentBlueprintId", contentBlueprintId);
        // We need to keep blueprintModuleCompleteKey as macro parameter
        // We use it when resolving which BP is to be applied (in case of customisations) when rendering the macro
        contentReportTableMacroParams.put("blueprintModuleCompleteKey", blueprintModuleCompleteKey);

        return templateRendererHelper.renderMacroXhtml("content-report-table", contentReportTableMacroParams);
    }

    public void setTemplateRendererHelper(TemplateRendererHelper templateRendererHelper) {
        this.templateRendererHelper = templateRendererHelper;
    }
}
