package com.atlassian.confluence.plugins.createcontent.activeobjects;

import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.plugins.createcontent.extensions.BlueprintDescriptor;
import net.java.ao.Entity;
import net.java.ao.OneToMany;
import net.java.ao.OneToOne;
import net.java.ao.Preload;

import java.io.Serializable;

/**
 * A plugin-agnostic representation of a {@link BlueprintDescriptor} that can wrap a {@link PageTemplate}.
 *
 * @since 1.6
 */
@Preload
public interface ContentBlueprintAo extends Entity, Serializable, PluginBackedBlueprintAo {
    @OneToMany(reverse = "getContentBlueprintParent")
    ContentTemplateRefAo[] getContentTemplates();

    @OneToOne(reverse = "getContentBlueprintIndexParent")
    ContentTemplateRefAo getIndexTemplateRef();

    String getIndexKey();

    void setIndexKey(String indexKey);

    String getCreateResult();

    void setCreateResult(String createResult);

    String getIndexTitleI18nKey();

    void setIndexTitleI18nKey(String indexTitleI18nKey);

    String getHowToUseTemplate();

    void setHowToUseTemplate(String howToUseTemplate);

    String getSpaceKey();

    void setSpaceKey(String spaceKey);

    boolean isIndexDisabled();

    void setIndexDisabled(boolean indexDisabled);
}
