package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.confluence.plugins.createcontent.activeobjects.ContentBlueprintAo;
import com.atlassian.confluence.plugins.createcontent.api.services.ContentBlueprintService;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.ModuleCompleteKey;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;

/**
 * Stores and retrieves {@link ContentBlueprint}s for use with the {@link ContentBlueprintService}.
 *
 * @since 1.6
 */
public interface ContentBlueprintManager extends AoBackedManager<ContentBlueprint, ContentBlueprintAo> {
    /**
     * Gets or creates a content blueprint clone in AO if its enabled, given its module complete moduleCompleteKey.
     *
     * @param moduleCompleteKey module complete key of the blueprint module
     * @return a cloned content blueprint, null if blueprint module is disabled
     */
    @Nullable
    ContentBlueprint getPluginBlueprint(ModuleCompleteKey moduleCompleteKey);

    /**
     * Gets all objects for this manager
     *
     * @return a list with all the objects for this manager
     */
    @Nonnull
    List<ContentBlueprint> getAll(Space space);

    /**
     *
     * @param spaceKey the key of the space
     * @return a list with all the {@link ContentBlueprint} objects
     * @since 10.1.0
     */
    @Nonnull
    List<ContentBlueprint> getAllBySpaceKey(String spaceKey);

    /**
     * Returns a ContentBlueprint that originally came from a Plugin (and hence has a module complete key) but may have
     * a customised version for the given space.
     */
    @Nullable
    ContentBlueprint getPluginBackedContentBlueprint(ModuleCompleteKey moduleCompleteKey, String spaceKey);

    /**
     * Returns the ContentBlueprint customised for the given space and having the specified module complete key.
     * If no customised Bp exists yet, it will be created. Note that if the space passed is null, a custom global
     * Blueprint will be retrieved.
     *
     * @param moduleCompleteKey key of original plugin Blueprint to be customised
     * @param space             space to look for overridden Blueprint - may be null for global
     * @return the new or existing Blueprint
     */
    ContentBlueprint getOrCreateCustomBlueprint(ModuleCompleteKey moduleCompleteKey, Space space);
}
