/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.rest;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.model.HibernateQueryCacheEntity;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.sf.hibernate.cache.QueryKey;
import net.sf.hibernate.cache.StandardQueryCache;
import org.ehcache.sizeof.Size;
import org.ehcache.sizeof.impl.UnsafeSizeOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/hibernate")
@Produces(value={"application/json"})
public class HibernateCacheResource {
    private static final Logger log = LoggerFactory.getLogger(HibernateCacheResource.class);
    private final PermissionManager permissionManager;
    private final CacheManager cacheManager;

    public HibernateCacheResource(PermissionManager permissionManager, CacheManager cacheManager) {
        this.permissionManager = permissionManager;
        this.cacheManager = cacheManager;
    }

    @GET
    @Path(value="queryCache")
    @Produces(value={"application/json"})
    public HibernateQueryCacheEntity getQueryCacheSummary() throws Exception {
        if (this.isAdmin()) {
            return this.buildQueryCacheSummary();
        }
        throw new WebApplicationException(Response.Status.FORBIDDEN);
    }

    private HibernateQueryCacheEntity buildQueryCacheSummary() throws NoSuchFieldException, IllegalAccessException {
        Field sqlQueryStringField = QueryKey.class.getDeclaredField("sqlQueryString");
        sqlQueryStringField.setAccessible(true);
        UnsafeSizeOf sizeOfEngine = new UnsafeSizeOf();
        HashMap queryCounts = Maps.newHashMap();
        for (QueryKey queryKey : this.hibernateQueryCache().getKeys()) {
            String sqlQueryString = (String)sqlQueryStringField.get(queryKey);
            if (!queryCounts.containsKey(sqlQueryString)) {
                queryCounts.put(sqlQueryString, new QueryAccumulator());
            }
            QueryAccumulator accumulator = (QueryAccumulator)queryCounts.get(sqlQueryString);
            ++accumulator.count;
            try {
                Size size = sizeOfEngine.deepSizeOf(1000, true, queryKey);
                accumulator.totalQueryKeySize = (int)((long)accumulator.totalQueryKeySize + size.getCalculated());
            }
            catch (RuntimeException ex) {
                log.info("Unable to calculate the size of QueryKey object with sqlQueryString [{}]", (Object)sqlQueryString);
            }
        }
        List<HibernateQueryCacheEntity.Query> queries = queryCounts.entrySet().stream().map(entry -> new HibernateQueryCacheEntity.Query((String)entry.getKey(), ((QueryAccumulator)entry.getValue()).count, ((QueryAccumulator)entry.getValue()).totalQueryKeySize)).collect(Collectors.toList());
        queries.sort((a, b) -> b.getTotalKeySizeBytes() - a.getTotalKeySizeBytes());
        return new HibernateQueryCacheEntity(queries);
    }

    private Cache<QueryKey, ?> hibernateQueryCache() {
        return this.cacheManager.getCache(StandardQueryCache.class.getName());
    }

    private boolean isAdmin() {
        return this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get());
    }

    private static class QueryAccumulator {
        int count;
        int totalQueryKeySize;

        private QueryAccumulator() {
        }
    }
}

