define('confluence-browser-metrics/marshallers/request-correlation-id-marshaller', [
    'confluence-browser-metrics/util/is-string'
], function (
    isString
) {
    function isRequestCorrelationIdReport(report) {
        return isString(report.requestCorrelationId);
    }

    var requestCorrelationIdMarshaller = function (report) {
        if (isRequestCorrelationIdReport(report)) {
            return { requestCorrelationId: report.requestCorrelationId };
        }
    };

    return requestCorrelationIdMarshaller;

});