/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.auditing.listeners;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.plugins.auditing.listeners.AbstractEventListener;
import com.atlassian.confluence.plugins.auditing.utils.AuditCategories;
import com.atlassian.confluence.plugins.auditing.utils.MessageKeyBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.events.WhitelistDisabledEvent;
import com.atlassian.plugins.whitelist.events.WhitelistEnabledEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleAddedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleChangedEvent;
import com.atlassian.plugins.whitelist.events.WhitelistRuleRemovedEvent;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="whitelistConfigurationEventListener")
public class WhitelistConfigurationEventListener
extends AbstractEventListener {
    private static final String WHITELIST_TURNED_ON = MessageKeyBuilder.buildSummaryTextKey("whitelist.turned.on");
    private static final String WHITELIST_TURNED_OFF = MessageKeyBuilder.buildSummaryTextKey("whitelist.turned.off");
    private static final String WHITELIST_ITEM_ADDED = MessageKeyBuilder.buildSummaryTextKey("whitelist.url.added");
    private static final String WHITELIST_ITEM_UPDATED = MessageKeyBuilder.buildSummaryTextKey("whitelist.url.updated");
    private static final String WHITELIST_ITEM_REMOVED = MessageKeyBuilder.buildSummaryTextKey("whitelist.url.removed");
    private static final String WHITELIST_CHANGED_VALUE_TYPE = MessageKeyBuilder.buildChangedValueTextKey("whitelist.url.type");
    private static final String WHITELIST_CHANGED_VALUE_EXPRESSION = MessageKeyBuilder.buildChangedValueTextKey("whitelist.url.expression");
    private static final String WHITELIST_CHANGED_VALUE_ALLOW_INCOMING = MessageKeyBuilder.buildChangedValueTextKey("whitelist.url.allow.incoming");

    @Autowired
    public WhitelistConfigurationEventListener(@ComponentImport AuditService auditBroker, @ComponentImport(value="eventPublisher") EventListenerRegistrar eventListenerRegistrar, @ComponentImport I18nResolver i18nResolver, @ComponentImport LocaleResolver localeResolver) {
        super(auditBroker, eventListenerRegistrar, i18nResolver, localeResolver);
    }

    @EventListener
    public void onWhitelistTurnedOn(WhitelistEnabledEvent event) {
        this.saveToBroker(() -> AuditEvent.builder((AuditType)this.getAuditType(WHITELIST_TURNED_ON)).build());
    }

    @EventListener
    public void onWhitelistTurnedOff(WhitelistDisabledEvent event) {
        this.saveToBroker(() -> AuditEvent.builder((AuditType)this.getAuditType(WHITELIST_TURNED_OFF)).build());
    }

    @EventListener
    public void onWhitelistRuleAdded(WhitelistRuleAddedEvent event) {
        this.saveToBroker(() -> AuditEvent.builder((AuditType)this.getAuditType(WHITELIST_ITEM_ADDED)).changedValues(this.extractChangedValues(event)).build());
    }

    @EventListener
    public void onWhitelistRuleUpdated(WhitelistRuleChangedEvent event) {
        this.saveToBroker(() -> AuditEvent.builder((AuditType)this.getAuditType(WHITELIST_ITEM_UPDATED)).changedValues(this.extractChangedValues(event)).build());
    }

    @EventListener
    public void onWhitelistRuleRemoved(WhitelistRuleRemovedEvent event) {
        this.saveToBroker(() -> AuditEvent.builder((AuditType)this.getAuditType(WHITELIST_ITEM_REMOVED)).changedValues(this.extractChangedValues(event)).build());
    }

    private List<ChangedValue> extractChangedValues(WhitelistRuleAddedEvent event) {
        return ImmutableList.of(new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_TYPE), event.getWhitelistRule().getType().toString()), new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_EXPRESSION), event.getWhitelistRule().getExpression()), new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_ALLOW_INCOMING), String.valueOf(event.getWhitelistRule().isAllowInbound())));
    }

    private List<ChangedValue> extractChangedValues(WhitelistRuleChangedEvent event) {
        return Stream.of(new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_TYPE), (String)Optional.ofNullable(event.getOldRule()).map(WhitelistRule::getType).map(Enum::toString).orElse(null), event.getNewRule().getType().toString()), new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_EXPRESSION), (String)Optional.ofNullable(event.getOldRule()).map(WhitelistRule::getExpression).orElse(null), event.getNewRule().getExpression()), new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_ALLOW_INCOMING), (String)Optional.ofNullable(event.getOldRule()).map(WhitelistRule::isAllowInbound).map(String::valueOf).orElse(null), String.valueOf(event.getNewRule().isAllowInbound()))).filter(cv -> !Objects.equals(cv.getFrom(), cv.getTo())).collect(Collectors.toList());
    }

    private List<ChangedValue> extractChangedValues(WhitelistRuleRemovedEvent event) {
        return ImmutableList.of(new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_TYPE), event.getWhitelistRule().getType().toString(), null), new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_EXPRESSION), event.getWhitelistRule().getExpression(), null), new ChangedValue(this.translate(WHITELIST_CHANGED_VALUE_ALLOW_INCOMING), String.valueOf(event.getWhitelistRule().isAllowInbound()), null));
    }

    private AuditType getAuditType(String actionKey) {
        return new AuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, this.translate(AuditCategories.ADMIN_CATEGORY), this.translate(actionKey), CoverageLevel.ADVANCED);
    }
}

