/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.auditing.listeners;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.plugins.auditing.listeners.AbstractEventListener;
import com.atlassian.confluence.plugins.auditing.utils.AuditCategories;
import com.atlassian.confluence.plugins.auditing.utils.ChangedValuesCalculator;
import com.atlassian.confluence.plugins.auditing.utils.MessageKeyBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.custom_apps.api.CustomApp;
import com.atlassian.plugins.custom_apps.api.events.NavigationLinkAddedEvent;
import com.atlassian.plugins.custom_apps.api.events.NavigationLinkRemovedEvent;
import com.atlassian.plugins.custom_apps.api.events.NavigationLinkUpdatedEvent;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.links.NavigationLinkBase;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="navigationLinksAuditListener")
public class NavigationLinksAuditListener
extends AbstractEventListener {
    private static final String NAVIGATION_LINK_AUDIT_PREFIX = "nav.link.";
    private final I18nResolver i18nResolver;
    private final LocaleResolver localeResolver;

    @Autowired
    public NavigationLinksAuditListener(AuditService auditBroker, EventListenerRegistrar eventListenerRegistrar, @ComponentImport I18nResolver i18nResolver, @ComponentImport LocaleResolver localeResolver) {
        super(auditBroker, eventListenerRegistrar, i18nResolver, localeResolver);
        this.i18nResolver = i18nResolver;
        this.localeResolver = localeResolver;
    }

    @EventListener
    public void onNavLinkAddedEvent(NavigationLinkAddedEvent event) {
        this.saveToBroker(() -> AuditEvent.builder((AuditType)this.buildNavLinkAuditType("created")).affectedObject(this.buildAuditResource(event.getAffectedApp()).build()).changedValues(this.compareApps(null, event.getAffectedApp())).build());
    }

    @EventListener
    public void onNavLinkUpdatedEvent(NavigationLinkUpdatedEvent event) {
        this.saveToBroker(() -> AuditEvent.builder((AuditType)this.buildNavLinkAuditType("updated")).affectedObject(this.buildAuditResource(event.getAffectedApp()).build()).changedValues(this.compareApps(event.getOldValue(), event.getAffectedApp())).build());
    }

    @EventListener
    public void onNavigationLinkRemovedEvent(NavigationLinkRemovedEvent event) {
        this.saveToBroker(() -> AuditEvent.builder((AuditType)this.buildNavLinkAuditType("removed")).affectedObject(this.buildAuditResource(event.getAffectedApp()).build()).changedValues(this.compareApps(event.getAffectedApp(), null)).build());
    }

    private AuditType buildNavLinkAuditType(String i18NSuffix) {
        return new AuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, super.translate(AuditCategories.ADMIN_CATEGORY), this.translate(i18NSuffix), CoverageLevel.ADVANCED);
    }

    private AuditResource.Builder buildAuditResource(CustomApp app) {
        String appName = app.getUrl();
        String appLinkObjectName = this.translate("nav.link");
        return AuditResource.builder((String)appName, (String)appLinkObjectName).id(app.getId()).uri(app.getUrl());
    }

    @Override
    String translate(String key) {
        return super.translate(MessageKeyBuilder.buildSummaryTextKey(NAVIGATION_LINK_AUDIT_PREFIX + key.toLowerCase()));
    }

    private List<ChangedValue> compareApps(CustomApp app, CustomApp otherApp) {
        ChangedValuesCalculator<CustomApp> customAppCalc = new ChangedValuesCalculator<CustomApp>(this.i18nResolver, this.localeResolver, app, otherApp);
        ChangedValuesCalculator<NavigationLink> navLinkCalc = new ChangedValuesCalculator<NavigationLink>(this.i18nResolver, this.localeResolver, app != null ? app.getNavigationLink() : null, otherApp != null ? otherApp.getNavigationLink() : null);
        return Stream.of(customAppCalc.getDifference("allowed.groups", CustomApp::getAllowedGroups), customAppCalc.getDifference("display.name", CustomApp::getDisplayName), customAppCalc.getDifference("hidden", CustomApp::getHide), customAppCalc.getDifference("source.application.type", CustomApp::getSourceApplicationType), navLinkCalc.getDifference("navigation.link.href", NavigationLinkBase::getHref)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

