/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.module.xmlrpc.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.functest.module.xmlrpc.content.ContentHelperService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;

public class ContentHelperServiceDelegate
implements ContentHelperService {
    private LabelManager labelManager;
    private NotificationManager notificationManager;
    private PageManager pageManager;

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    private ContentEntityObject getContentEntityObject(String entityId) {
        long pageId = Long.parseLong(entityId);
        return this.pageManager.getById(pageId);
    }

    private AbstractPage getPage(String pageIdStr) {
        long pageId = Long.parseLong(pageIdStr);
        return this.pageManager.getAbstractPage(pageId);
    }

    private Notification getNotification(AbstractPage abstractPage) {
        return null == abstractPage ? null : this.notificationManager.getNotificationByUserAndPage(AuthenticatedUserThreadLocal.getUser(), abstractPage);
    }

    public boolean addWatch(String authenticationToken, String entityId) {
        AbstractPage abstractPage = this.getPage(entityId);
        if (null == abstractPage) {
            return false;
        }
        if (null != this.getNotification(abstractPage)) {
            return false;
        }
        this.notificationManager.addPageNotification(AuthenticatedUserThreadLocal.getUser(), abstractPage);
        return true;
    }

    public boolean removeWatch(String authenticationToken, String entityId) {
        AbstractPage abstractPage = this.getPage(entityId);
        if (null == abstractPage) {
            return false;
        }
        Notification notification = this.getNotification(abstractPage);
        if (null == notification) {
            return false;
        }
        this.notificationManager.removeNotification(notification);
        return true;
    }

    public boolean isWatched(String authenticationToken, String entityId) {
        return null != this.getNotification(this.getPage(entityId));
    }

    public boolean markFavorite(String authenticationToken, String entityId) {
        ContentEntityObject contentEntityObject = this.getContentEntityObject(entityId);
        if (null == contentEntityObject) {
            return false;
        }
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (contentEntityObject.isFavourite(currentUser)) {
            return false;
        }
        this.labelManager.addLabel(contentEntityObject, new Label("favourite", Namespace.PERSONAL, currentUser.getName()));
        return true;
    }

    public boolean unmarkFavorite(String authentictionToken, String entityId) {
        ContentEntityObject contentEntityObject = this.getContentEntityObject(entityId);
        if (null == contentEntityObject) {
            return false;
        }
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!contentEntityObject.isFavourite(currentUser)) {
            return false;
        }
        String userName = currentUser.getName();
        this.labelManager.removeLabel(contentEntityObject, new Label("favourite", Namespace.PERSONAL, userName));
        this.labelManager.removeLabel(contentEntityObject, new Label("favorite", Namespace.PERSONAL, userName));
        return true;
    }

    public boolean isFavorite(String authenticationToken, String entityId) {
        ContentEntityObject ceo = this.getContentEntityObject(entityId);
        return null != ceo && ceo.isFavourite(AuthenticatedUserThreadLocal.getUser());
    }

    public String login(String s, String s1) {
        return null;
    }

    public boolean logout(String s) {
        return false;
    }
}

