/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.helper;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.helper.AbstractHelper;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class GroupHelper
extends AbstractHelper {
    private static final Logger LOG = Logger.getLogger((Class)GroupHelper.class);
    private String name;

    public GroupHelper(ConfluenceWebTester confluenceWebTester, String name) {
        super(confluenceWebTester);
        this.setName(name);
    }

    public GroupHelper(ConfluenceWebTester confluenceWebTester) {
        this(confluenceWebTester, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            confluenceSoapService.addGroup(soapSessionToken, this.getName());
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = confluenceSoapService.hasGroup(soapSessionToken, this.getName());
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    public boolean update() {
        throw new UnsupportedOperationException("Group edits currently not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = confluenceSoapService.removeGroup(soapSessionToken, this.getName(), null);
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }
}

