/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.helper;

import com.atlassian.confluence.ConfluenceSoapService;
import com.atlassian.confluence.plugin.helper.AbstractHelper;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.rpc.ServiceException;

public abstract class ContentHelper
extends AbstractHelper {
    private long id;
    private String content;
    private String creator;
    private Date creationDate;
    private int version;

    protected ContentHelper(long id) {
        this.setId(id);
    }

    protected ContentHelper() {
        this(0L);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveOrUpdate() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = this.storeRemoteContentAndUpdateHelper(soapSessionToken, confluenceSoapService);
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    public boolean create() {
        return this.saveOrUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = this.readRemoteContentAndUpdateHelper(soapSessionToken, confluenceSoapService);
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    public boolean update() {
        return this.saveOrUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = this.deleteRemoteContent(soapSessionToken, confluenceSoapService);
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    protected abstract boolean storeRemoteContentAndUpdateHelper(String var1, ConfluenceSoapService var2) throws MalformedURLException, ServiceException, RemoteException;

    protected abstract boolean readRemoteContentAndUpdateHelper(String var1, ConfluenceSoapService var2) throws MalformedURLException, ServiceException, RemoteException;

    protected abstract boolean deleteRemoteContent(String var1, ConfluenceSoapService var2) throws MalformedURLException, ServiceException, RemoteException;
}

