/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.word;

import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.extra.officeconnector.index.util.AttachmentTextExtractorAdapter;
import com.atlassian.confluence.index.attachment.AttachmentTextExtractor;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.util.io.InputStreamSource;
import com.atlassian.plugins.conversion.extract.xml.WordXMLExtractor;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class WordXMLTextExtractor
extends BaseAttachmentContentExtractor
implements AttachmentTextExtractor {
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.Word, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.Word, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final long MAX_XML_SIZE = Long.getLong("officeconnector.textextract.word.docxmaxsize", 0x1000000L);

    public List<String> getFileExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<String> getMimeTypes() {
        return Arrays.asList(CONTENT_TYPES);
    }

    public Optional<InputStreamSource> extract(Attachment attachment) {
        return new AttachmentTextExtractorAdapter((Extractor)this).apply(attachment);
    }

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    protected String extractText(InputStream inputStream, SearchableAttachment attachment) throws ExtractorException {
        try {
            return WordXMLExtractor.extractText((InputStream)inputStream, (long)MAX_XML_SIZE);
        }
        catch (Exception e) {
            throw new ExtractorException((Throwable)e);
        }
    }
}

