/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.powerpoint;

import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.extra.officeconnector.index.util.AttachmentTextExtractorAdapter;
import com.atlassian.confluence.index.attachment.AttachmentTextExtractor;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.util.io.InputStreamSource;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PowerPointTextExtractor
extends BaseAttachmentContentExtractor
implements AttachmentTextExtractor {
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.PowerPoint, (OfficeFile.Version)OfficeFile.Version.V97).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.PowerPoint, (OfficeFile.Version)OfficeFile.Version.V97).toArray(new String[0]);

    public List<String> getFileExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<String> getMimeTypes() {
        return Arrays.asList(CONTENT_TYPES);
    }

    public Optional<InputStreamSource> extract(Attachment attachment) {
        return new AttachmentTextExtractorAdapter((Extractor)this).apply(attachment);
    }

    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        try {
            POIFSFileSystem system = new POIFSFileSystem(is);
            try {
                DirectoryNode root = system.getRoot();
                root.getEntry("Pictures").delete();
                root.createDocument("Pictures", (InputStream)new ByteArrayInputStream(new byte[0]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return new PowerPointExtractor(system).getText();
        }
        catch (Exception e) {
            throw new ExtractorException("Error reading content of PowerPoint document: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }
}

