/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.word;

import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.extra.officeconnector.index.AbstractAttachmentExtractor;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.plugins.conversion.extract.xml.WordXMLExtractor;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WordXMLTextExtractor
extends AbstractAttachmentExtractor {
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.Word, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.Word, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final long MAX_XML_SIZE = Long.getLong("officeconnector.textextract.word.docxmaxsize", 0x1000000L);
    private final AttachmentManager attachmentManager;

    public WordXMLTextExtractor(AttachmentManager attachmentManager) {
        this.attachmentManager = Objects.requireNonNull(attachmentManager);
    }

    public List<String> getFileExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<String> getMimeTypes() {
        return Arrays.asList(CONTENT_TYPES);
    }

    @Override
    protected AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    @Override
    protected String extractText(InputStream inputStream) throws ExtractorException {
        try {
            return WordXMLExtractor.extractText((InputStream)inputStream, (long)MAX_XML_SIZE);
        }
        catch (Exception e) {
            throw new ExtractorException((Throwable)e);
        }
    }
}

