/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index;

import com.atlassian.annotations.Internal;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.index.attachment.AttachmentTextExtractor;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.util.io.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractAttachmentExtractor
implements AttachmentTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(AbstractAttachmentExtractor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Optional<InputStreamSource> extract(Attachment attachment) {
        try (InputStream is = this.getAttachmentManager().getAttachmentData(attachment);){
            if (is == null) {
                log.warn("Encountered attachment {} with null stream", (Object)attachment.getIdAsString());
                Optional<InputStreamSource> optional2 = Optional.empty();
                return optional2;
            }
            log.debug("Starting to index attachment {}", (Object)attachment.getIdAsString());
            String text = this.extractText(is);
            Optional<InputStreamSource> optional = Optional.of(() -> IOUtils.toInputStream((String)text, (Charset)StandardCharsets.UTF_8));
            return optional;
        }
        catch (ExtractorException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract AttachmentManager getAttachmentManager();

    protected abstract String extractText(InputStream var1) throws ExtractorException;
}

