/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.icc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.icc.IccConstants;
import org.apache.sanselan.icc.IccTag;

public class IccProfileInfo
implements IccConstants {
    public final byte[] data;
    public final int ProfileSize;
    public final int CMMTypeSignature;
    public final int ProfileVersion;
    public final int ProfileDeviceClassSignature;
    public final int ColorSpace;
    public final int ProfileConnectionSpace;
    public final int ProfileFileSignature;
    public final int PrimaryPlatformSignature;
    public final int VariousFlags;
    public final int DeviceManufacturer;
    public final int DeviceModel;
    public final int RenderingIntent;
    public final int ProfileCreatorSignature;
    public final byte[] ProfileID;
    public final IccTag[] tags;

    public IccProfileInfo(byte[] data, int ProfileSize, int CMMTypeSignature, int ProfileVersion, int ProfileDeviceClassSignature, int ColorSpace, int ProfileConnectionSpace, int ProfileFileSignature, int PrimaryPlatformSignature, int VariousFlags, int DeviceManufacturer, int DeviceModel, int RenderingIntent, int ProfileCreatorSignature, byte[] ProfileID, IccTag[] tags) {
        this.data = data;
        this.ProfileSize = ProfileSize;
        this.CMMTypeSignature = CMMTypeSignature;
        this.ProfileVersion = ProfileVersion;
        this.ProfileDeviceClassSignature = ProfileDeviceClassSignature;
        this.ColorSpace = ColorSpace;
        this.ProfileConnectionSpace = ProfileConnectionSpace;
        this.ProfileFileSignature = ProfileFileSignature;
        this.PrimaryPlatformSignature = PrimaryPlatformSignature;
        this.VariousFlags = VariousFlags;
        this.DeviceManufacturer = DeviceManufacturer;
        this.DeviceModel = DeviceModel;
        this.RenderingIntent = RenderingIntent;
        this.ProfileCreatorSignature = ProfileCreatorSignature;
        this.ProfileID = ProfileID;
        this.tags = tags;
    }

    public boolean issRGB() {
        boolean result = this.DeviceManufacturer == 1229275936 && this.DeviceModel == 1934772034;
        return result;
    }

    private void printCharQuad(PrintWriter pw, String msg, int i) {
        pw.println(msg + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & i >> 0) + "'");
    }

    public void dump(String prefix) throws IOException {
        System.out.print(this.toString());
    }

    public String toString() {
        try {
            return this.toString("");
        }
        catch (Exception e) {
            return "IccProfileInfo: Error";
        }
    }

    public String toString(String prefix) throws ImageReadException, IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(prefix + ": " + "data length: " + this.data.length);
        this.printCharQuad(pw, prefix + ": " + "ProfileDeviceClassSignature", this.ProfileDeviceClassSignature);
        this.printCharQuad(pw, prefix + ": " + "CMMTypeSignature", this.CMMTypeSignature);
        this.printCharQuad(pw, prefix + ": " + "ProfileDeviceClassSignature", this.ProfileDeviceClassSignature);
        this.printCharQuad(pw, prefix + ": " + "ColorSpace", this.ColorSpace);
        this.printCharQuad(pw, prefix + ": " + "ProfileConnectionSpace", this.ProfileConnectionSpace);
        this.printCharQuad(pw, prefix + ": " + "ProfileFileSignature", this.ProfileFileSignature);
        this.printCharQuad(pw, prefix + ": " + "PrimaryPlatformSignature", this.PrimaryPlatformSignature);
        this.printCharQuad(pw, prefix + ": " + "ProfileFileSignature", this.ProfileFileSignature);
        this.printCharQuad(pw, prefix + ": " + "DeviceManufacturer", this.DeviceManufacturer);
        this.printCharQuad(pw, prefix + ": " + "DeviceModel", this.DeviceModel);
        this.printCharQuad(pw, prefix + ": " + "RenderingIntent", this.RenderingIntent);
        this.printCharQuad(pw, prefix + ": " + "ProfileCreatorSignature", this.ProfileCreatorSignature);
        for (int i = 0; i < this.tags.length; ++i) {
            IccTag tag = this.tags[i];
            tag.dump(pw, "\t" + i + ": ");
        }
        pw.println(prefix + ": " + "issRGB: " + this.issRGB());
        pw.flush();
        return sw.getBuffer().toString();
    }
}

