/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.extension.ClassIndexBeanDefinitionScanner;
import com.atlassian.plugin.spring.scanner.extension.ComponentImportBeanFactoryPostProcessor;
import com.atlassian.plugin.spring.scanner.extension.DevModeBeanInitialisationLoggerBeanPostProcessor;
import com.atlassian.plugin.spring.scanner.extension.ServiceExporterBeanPostProcessor;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class AtlassianScannerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String AUTO_IMPORTS_ATTRIBUTE = "auto-imports";
    private static final String PROFILE_ATTRIBUTE = "profile";
    public static final String JAVAX_INJECT_CLASSNAME = "javax.inject.Inject";
    private final Log log = LogFactory.getLog(this.getClass());

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean autoImports = false;
        String profileName = null;
        Integer autowireDefault = null;
        if (element.hasAttribute(AUTO_IMPORTS_ATTRIBUTE)) {
            autoImports = Boolean.parseBoolean(element.getAttribute(AUTO_IMPORTS_ATTRIBUTE));
        }
        if (element.hasAttribute(PROFILE_ATTRIBUTE)) {
            profileName = element.getAttribute(PROFILE_ATTRIBUTE);
        }
        if (element.hasAttribute("autowire")) {
            autowireDefault = parserContext.getDelegate().getAutowireMode(element.getAttribute("autowire"));
        }
        BundleContext bundleContext = this.getBundleContext();
        ClassIndexBeanDefinitionScanner scanner = new ClassIndexBeanDefinitionScanner(parserContext.getReaderContext().getRegistry(), profileName, autowireDefault, bundleContext);
        Set<BeanDefinitionHolder> beanDefinitions = scanner.doScan();
        this.registerComponents(parserContext.getReaderContext(), beanDefinitions, element, autoImports, profileName);
        return null;
    }

    protected void registerComponents(XmlReaderContext readerContext, Set<BeanDefinitionHolder> beanDefinitions, Element element, boolean autoImports, String profileName) {
        Object source = readerContext.extractSource((Object)element);
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), source);
        for (BeanDefinitionHolder beanDefHolder : beanDefinitions) {
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(beanDefHolder));
        }
        LinkedHashSet<BeanDefinitionHolder> processorDefinitions = new LinkedHashSet<BeanDefinitionHolder>();
        processorDefinitions.addAll(AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)readerContext.getRegistry(), (Object)source));
        BeanDefinitionHolder javaxInject = this.getJavaxInjectPostProcessor(readerContext.getRegistry(), source);
        if (null != javaxInject) {
            processorDefinitions.add(javaxInject);
        }
        processorDefinitions.add(this.getComponentImportPostProcessor(readerContext.getRegistry(), source, autoImports, profileName));
        processorDefinitions.add(this.getServiceExportPostProcessor(readerContext.getRegistry(), source, profileName));
        processorDefinitions.add(this.getDevModeBeanInitialisationLoggerPostProcessor(readerContext.getRegistry(), source));
        for (BeanDefinitionHolder processorDefinition : processorDefinitions) {
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(processorDefinition));
        }
        readerContext.fireComponentRegistered((ComponentDefinition)compositeDef);
    }

    private BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(AtlassianScannerBeanDefinitionParser.class).getBundleContext();
    }

    private BeanDefinitionHolder getJavaxInjectPostProcessor(BeanDefinitionRegistry registry, Object source) {
        if (ClassUtils.isPresent((String)JAVAX_INJECT_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
            try {
                Class<?> injectClass = this.getClass().getClassLoader().loadClass(JAVAX_INJECT_CLASSNAME);
                HashMap properties = new HashMap();
                properties.put("autowiredAnnotationType", injectClass);
                RootBeanDefinition def = new RootBeanDefinition(AutowiredAnnotationBeanPostProcessor.class);
                def.setSource(source);
                def.setRole(2);
                def.setPropertyValues(new MutablePropertyValues(properties));
                return this.registerBeanPostProcessor(registry, def, "javaxInjectBeanPostProcessor");
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)"Unable to load class 'javax.inject.Inject' for javax component purposes.  Not sure how this is possible.  Skipping...");
            }
        }
        return null;
    }

    private BeanDefinitionHolder registerBeanPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
        return new BeanDefinitionHolder((BeanDefinition)definition, beanName);
    }

    private BeanDefinitionHolder getComponentImportPostProcessor(BeanDefinitionRegistry registry, Object source, boolean autoImports, String profileName) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("autoImports", autoImports);
        properties.put("profileName", profileName);
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(ComponentImportBeanFactoryPostProcessor.class);
        rootBeanDefinition.setAutowireMode(3);
        rootBeanDefinition.setSource(source);
        rootBeanDefinition.setPropertyValues(new MutablePropertyValues(properties));
        return this.registerBeanPostProcessor(registry, rootBeanDefinition, "componentImportBeanFactoryPostProcessor");
    }

    private BeanDefinitionHolder getServiceExportPostProcessor(BeanDefinitionRegistry registry, Object source, String profileName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("profileName", profileName);
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(ServiceExporterBeanPostProcessor.class);
        rootBeanDefinition.setSource(source);
        rootBeanDefinition.setAutowireMode(3);
        rootBeanDefinition.setPropertyValues(new MutablePropertyValues(properties));
        return this.registerBeanPostProcessor(registry, rootBeanDefinition, "serviceExportBeanPostProcessor");
    }

    private BeanDefinitionHolder getDevModeBeanInitialisationLoggerPostProcessor(BeanDefinitionRegistry registry, Object source) {
        RootBeanDefinition def = new RootBeanDefinition(DevModeBeanInitialisationLoggerBeanPostProcessor.class);
        def.setSource(source);
        def.setAutowireMode(3);
        return this.registerBeanPostProcessor(registry, def, "devModeBeanInitialisationLoggerBeanPostProcessor");
    }
}

