/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.image.effects.ImageDimensionsHelper;
import com.atlassian.confluence.setup.settings.DarkFeatures;
import com.atlassian.imageeffects.core.BaseEffect;
import java.awt.Dimension;
import java.awt.FontFormatException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ImageFilterUtils {
    private static final int DIMENSION_MAX = Integer.getInteger("atlassian.image_filter.transform.max.pixel", 4000);
    private static Pattern exifDownloadPattern = Pattern.compile("/download/(attachments|thumbnails)/(\\d+)/([^\\?\\n\\r]+(\\.(?i)(jpg|tif)))(\\?version\\=(\\d+))?");

    public static boolean isImageTooBig(InputStream in) throws IOException {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(in);){
            Dimension imageDims = ImageDimensionsHelper.dimensionsForImage(imageInputStream);
            int dimSquared = (int)(imageDims.getHeight() * imageDims.getWidth());
            boolean bl = dimSquared > DIMENSION_MAX * DIMENSION_MAX;
            return bl;
        }
    }

    public static byte[] renderImage(BufferedImage img) throws IOException {
        return ImageFilterUtils.renderImage(img, "jpg");
    }

    /*
     * Exception decompiling
     */
    public static byte[] renderImage(BufferedImage img, String format) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getImageFormat(InputStream inputStream) throws IOException {
        inputStream.mark(Integer.MAX_VALUE);
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(imageInputStream);
            ImageReader imageReader = readers.next();
            if (imageReader == null) {
                throw new IOException("Could not find the image reader.");
            }
            inputStream.reset();
            String string = imageReader.getFormatName();
            return string;
        }
    }

    public static <T extends AutoCloseable> QuietlyCloseableResource<T> quietlyCloseable(T resource) {
        return new QuietlyCloseableResource<T>(resource);
    }

    public static ImageEffectFunction imageEffectFunction(String label) {
        return new ImageEffectFunction(label);
    }

    public static String applyExifRotateEffect(HttpServletRequest request, String effects) {
        Matcher matcher;
        String download = request.getParameter("download");
        if (download == null && !DarkFeatures.isDarkFeatureEnabled((String)"imageFilter.exif.rotate.disabled") && (matcher = exifDownloadPattern.matcher(request.getRequestURL().append("?").append(request.getQueryString()))).find()) {
            effects = StringUtils.isEmpty((CharSequence)effects) ? "exif-rotate" : "exif-rotate," + effects;
        }
        return effects;
    }

    public static class ImageEffectFunction
    implements BiFunction<BufferedImage, BaseEffect, BufferedImage> {
        private final String label;

        public ImageEffectFunction(String label) {
            this.label = label;
        }

        @Override
        public BufferedImage apply(BufferedImage bufferedImage, BaseEffect baseEffect) {
            try {
                return baseEffect.processEffect(bufferedImage, this.label);
            }
            catch (FontFormatException | IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class QuietlyCloseableResource<T extends AutoCloseable>
    implements AutoCloseable {
        private static final Logger LOG = LoggerFactory.getLogger(QuietlyCloseableResource.class);
        private final T resource;

        public QuietlyCloseableResource(T resource) {
            this.resource = resource;
        }

        public T get() {
            return this.resource;
        }

        @Override
        public void close() {
            try {
                this.resource.close();
            }
            catch (Exception e) {
                LOG.warn("Unexpected error whilst closing resource", (Throwable)e);
            }
        }
    }
}

