/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.image.effects.ImageFilterUtils;
import com.atlassian.confluence.image.effects.TransformContext;
import com.atlassian.confluence.image.effects.TransformFailure;
import com.atlassian.confluence.image.effects.analytics.ImageRotationByExifEvent;
import com.atlassian.confluence.image.effects.analytics.ImageSizeTooLargeEvent;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.core.util.thumbnail.Dimensions;
import com.atlassian.core.util.thumbnail.DimensionsHelper;
import com.atlassian.fugue.Either;
import com.atlassian.imageeffects.client.Failure;
import com.atlassian.imageeffects.client.Success;
import com.atlassian.imageeffects.core.BaseEffect;
import com.atlassian.imageeffects.core.BlurBorderEffect;
import com.atlassian.imageeffects.core.DropShadowEffect;
import com.atlassian.imageeffects.core.GlassEffect;
import com.atlassian.imageeffects.core.MirrorEffect;
import com.atlassian.imageeffects.core.PolaroidBorderEffect;
import com.atlassian.imageeffects.core.RotateEffect;
import com.atlassian.imageeffects.core.ScaleForThumbEffect;
import com.atlassian.imageeffects.core.ShadowKnEffect;
import com.atlassian.imageeffects.core.SimpleBorderEffect;
import com.atlassian.imageeffects.core.TapeForThumbEffect;
import com.atlassian.imageeffects.core.ThumbnailEffect;
import com.atlassian.imageeffects.core.exif.ExifException;
import com.atlassian.imageeffects.core.exif.ExifInfo;
import com.atlassian.imageeffects.core.exif.ExifService;
import com.google.common.collect.ImmutableList;
import java.awt.FontFormatException;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ImageFilterTask
implements Callable<Either<TransformFailure, byte[]>> {
    private static final Logger log = LoggerFactory.getLogger(ImageFilterTask.class);
    private static final ImmutableList<BaseEffect> IMAGE_EFFECTS = ImmutableList.of((Object)new ThumbnailEffect("thumbnail"), (Object)new MirrorEffect("mirror"), (Object)new RotateEffect("rotate"), (Object)new SimpleBorderEffect("border-simple"), (Object)new PolaroidBorderEffect("border-polaroid"), (Object)new DropShadowEffect("drop-shadow"), (Object)new ShadowKnEffect("shadow-kn"), (Object)new BlurBorderEffect("blur-border"), (Object)new ScaleForThumbEffect("scaleForThumb"), (Object)new TapeForThumbEffect("tapeForThumb"), (Object)new GlassEffect("glass"));
    private final TransformContext context;
    private final String[] effectList;
    private final ExifService exifService;
    private final SettingsManager settingsManager;

    public ImageFilterTask(TransformContext context, String[] effectList, ExifService exifService, SettingsManager settingsManager) {
        this.context = Objects.requireNonNull(context);
        this.effectList = Objects.requireNonNull(effectList);
        this.exifService = exifService;
        this.settingsManager = settingsManager;
    }

    @Override
    public Either<TransformFailure, byte[]> call() throws IOException, FontFormatException {
        if (this.isImageDataMissing()) {
            return ImageFilterTask.transformFailure(TransformFailure.Reason.IMAGE_DATA_MISSING);
        }
        if (this.context.isRotationAndThumbnailOnly()) {
            return this.processRotationAndThumbnail();
        }
        if (this.context.getImageDataSize() > (long)this.context.getConfig().getTransformMaxDataSize()) {
            log.debug("Could not process the image as the image size is too big.");
            this.context.getEventPublisher().publish((Object)new ImageSizeTooLargeEvent(this.context.getImageDataSize(), this.context.getCacheEntryName()));
            if (this.context.isRotationOnly()) {
                return this.readOriginalImage();
            }
            return ImageFilterTask.transformFailure(TransformFailure.Reason.IMAGE_DATA_TOO_LARGE);
        }
        if (this.context.getClient().isPresent()) {
            return this.processViaRemoteClient();
        }
        return this.processInMemory();
    }

    /*
     * Exception decompiling
     */
    private Either<TransformFailure, byte[]> processRotationAndThumbnail() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Either<TransformFailure, byte[]> generateThumbnail(InputStream inputStream) {
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(imageInputStream);
            ImageReader imageReader = readers.next();
            if (imageReader == null) {
                Either either2 = Either.left((Object)new TransformFailure(TransformFailure.Reason.TRANSFORM_FAILURE));
                return either2;
            }
            imageReader.setInput(imageInputStream);
            ImageReadParam param = imageReader.getDefaultReadParam();
            int samplingPeriod = this.getSamplingPeriod(imageReader.getWidth(0), imageReader.getHeight(0));
            param.setSourceSubsampling(samplingPeriod, samplingPeriod, 0, 0);
            BufferedImage scaledImage = imageReader.read(0, param);
            Either either = Either.right((Object)ImageFilterUtils.renderImage(scaledImage, imageReader.getFormatName()));
            return either;
        }
        catch (IOException e) {
            return ImageFilterTask.transformFailure(e);
        }
    }

    private int getSamplingPeriod(int imageWidth, int imageHeight) {
        Dimensions dimensions = new DimensionsHelper().determineScaledDimensions(this.settingsManager.getGlobalSettings().getMaxThumbWidth(), this.settingsManager.getGlobalSettings().getMaxThumbHeight(), imageWidth, imageHeight);
        return (int)Math.round((double)imageWidth / (double)dimensions.getWidth());
    }

    private static Either<TransformFailure, byte[]> transformFailure(TransformFailure.Reason reason) {
        return Either.left((Object)new TransformFailure(reason));
    }

    private static Either<TransformFailure, byte[]> transformFailure(Throwable cause) {
        if (cause instanceof RuntimeException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        return Either.left((Object)new TransformFailure(TransformFailure.Reason.TRANSFORM_FAILURE, cause));
    }

    @Nonnull
    private Either<TransformFailure, byte[]> processInMemory() {
        log.debug("Processing transformation in memory");
        try {
            if (this.inMemoryImagePixelTooLarge()) {
                log.debug("Could not process the image as the image size is too big.");
                this.context.getEventPublisher().publish((Object)new ImageSizeTooLargeEvent(this.context.getImageDataSize(), this.context.getCacheEntryName()));
                if (this.context.isRotationOnly()) {
                    return this.readOriginalImage();
                }
                return ImageFilterTask.transformFailure(TransformFailure.Reason.IMAGE_PIXEL_TOO_LARGE);
            }
            return Either.right((Object)this.inMemoryTransform());
        }
        catch (Exception e) {
            return ImageFilterTask.transformFailure(e);
        }
    }

    private Either<TransformFailure, byte[]> readOriginalImage() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)((InputStream)this.context.getImageSupplier().get()), (OutputStream)outputStream);
            return Either.right((Object)outputStream.toByteArray());
        }
        catch (IOException e) {
            return ImageFilterTask.transformFailure(e);
        }
    }

    private boolean isImageDataMissing() throws IOException {
        try (InputStream inputStream = (InputStream)this.context.getImageSupplier().get();){
            boolean bl = inputStream == null;
            return bl;
        }
    }

    private boolean inMemoryImagePixelTooLarge() throws IOException {
        try (InputStream originalStream = (InputStream)this.context.getImageSupplier().get();){
            boolean bl = ImageFilterUtils.isImageTooBig(originalStream);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage rotateWhenExifExist(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            ExifInfo exifInfo = this.exifService.readExifInfo(bufferedInputStream);
            if (exifInfo == null || exifInfo.getOrientation() == null) {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream((byte[])this.readOriginalImage().right().get()));
                return bufferedImage;
            }
            long startTime = System.currentTimeMillis();
            BufferedImage rotatedImage = this.exifService.rotate(bufferedInputStream, exifInfo);
            this.context.getEventPublisher().publish((Object)new ImageRotationByExifEvent(this.context.getImageDataSize(), "", this.context.getCacheEntryName(), this.context.isRotationOnly(), this.context.isRotationAndThumbnailOnly(), true, System.currentTimeMillis() - startTime));
            BufferedImage bufferedImage = rotatedImage;
            return bufferedImage;
        }
        catch (ExifException e) {
            log.warn("Could not retrieve exif info.", (Throwable)e);
            this.context.getEventPublisher().publish((Object)new ImageRotationByExifEvent(this.context.getImageDataSize(), e.getMessage(), this.context.getCacheEntryName(), this.context.isRotationOnly(), this.context.isRotationAndThumbnailOnly(), false, 0L));
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream((byte[])this.readOriginalImage().right().get()));
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    private byte[] inMemoryTransform() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    private Either<TransformFailure, byte[]> processViaRemoteClient() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 24[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean remoteReturnImageTooBigWhenRotationOnly(Either<Failure, Success<byte[]>> result) {
        return result.isLeft() && this.context.isRotationOnly() && Failure.Reason.IMAGE_TOO_LARGE.equals((Object)((Failure)result.left().get()).getReason());
    }

    @Nonnull
    private TransformFailure clientMapFailure(Failure failure) {
        TransformFailure.Reason reason;
        switch (failure.getReason()) {
            case IMAGE_TOO_LARGE: {
                reason = TransformFailure.Reason.IMAGE_PIXEL_TOO_LARGE;
                break;
            }
            default: {
                reason = TransformFailure.Reason.TRANSFORM_FAILURE;
            }
        }
        log.debug("Mapped failure {} to {}", new Object[]{failure.getReason(), reason, failure.getCause().getOrNull()});
        return failure.getCause().isDefined() ? new TransformFailure(reason, (Throwable)failure.getCause().get()) : new TransformFailure(reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageFilterTask that = (ImageFilterTask)o;
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        return Arrays.equals(this.effectList, that.effectList);
    }

    public int hashCode() {
        int result = this.context != null ? this.context.hashCode() : 0;
        result = 31 * result + (this.effectList != null ? Arrays.hashCode(this.effectList) : 0);
        return result;
    }

    private static /* synthetic */ byte[] lambda$processViaRemoteClient$3(InputStream transformedStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)transformedStream, (OutputStream)baos);
        return baos.toByteArray();
    }

    private static /* synthetic */ BufferedImage lambda$inMemoryTransform$2(BufferedImage l, BufferedImage r) {
        return null;
    }

    private static /* synthetic */ Stream lambda$inMemoryTransform$1(String effectName) {
        return IMAGE_EFFECTS.stream().filter(imageEffect -> imageEffect.handles(effectName));
    }
}

