/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.image.effects.ImageFilterUtils;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ImageFilterFilter
implements Filter {
    private static Pattern downloadPattern = Pattern.compile("/download/(attachments|thumbnails)/(\\d+)/([^\\?\\n\\r]+)(\\?version\\=(\\d+))?");

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq;
        Matcher matcher;
        String effects = ImageFilterUtils.applyExifRotateEffect((HttpServletRequest)request, request.getParameter("effects"));
        if (effects != null && (matcher = downloadPattern.matcher((httpReq = (HttpServletRequest)request).getRequestURL().append("?").append(httpReq.getQueryString()))).find()) {
            String type = matcher.group(1);
            String contentId = matcher.group(2);
            String fileName = matcher.group(3);
            Matcher thumbMatcher = downloadPattern.matcher(fileName);
            while (thumbMatcher.find()) {
                fileName = thumbMatcher.group(3);
                thumbMatcher = downloadPattern.matcher(fileName);
            }
            String version = matcher.group(5);
            if (type.equals("thumbnails")) {
                effects = effects + ",thumbnail";
            }
            String newUrl = "/plugins/servlet/imgFilter?ceo=" + contentId + "&image=" + fileName + "&effects=" + effects + (version != null ? "&version=" + version : "");
            RequestDispatcher dispatcher = request.getRequestDispatcher(newUrl);
            dispatcher.forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

