/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.image.effects.ImageEffectsClientSupplier;
import com.atlassian.confluence.image.effects.ImageEffectsConfig;
import com.atlassian.confluence.image.effects.ImageEffectsConfigChangedEvent;
import com.atlassian.confluence.util.zipkin.api.ZipkinHttpClientInterceptorManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.imageeffects.client.ConnectionDetails;
import com.atlassian.imageeffects.client.ConnectionDetailsBuilder;
import com.atlassian.imageeffects.client.ImageEffectsClient;
import com.atlassian.imageeffects.client.ImageEffectsClientFactory;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named(value="clientSupplier")
public class DefaultImageEffectsClientSupplier
extends ResettableLazyReference<Optional<ImageEffectsClient>>
implements ImageEffectsClientSupplier,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultImageEffectsClientSupplier.class);
    @Inject
    private ImageEffectsConfig config;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ZipkinHttpClientInterceptorManager httpClientInterceptorManager;

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onImageEffectsConfigChangedEvent(ImageEffectsConfigChangedEvent event) {
        log.info("Configuration changed, resetting reference");
        this.reset();
    }

    protected Optional<ImageEffectsClient> create() {
        return this.buildServiceUri().map(input -> {
            ConnectionDetails details = new ConnectionDetailsBuilder().serviceUri((URI)input).trustSelfSignedCerts(this.config.isClientTrustSelfies()).connectTimeout(this.config.getClientConnectTimeoutMs()).connectionTimeToLive(this.config.getClientConnectionTtlMs()).socketTimeout(this.config.getClientSocketTimeoutMs()).build();
            log.info("Creating client with connection details: {}", (Object)details);
            Iterable requestInterceptors = this.httpClientInterceptorManager.requestInterceptors("image-effects-microservice", (uri, httpMethod) -> httpMethod + " " + uri.getPath());
            return ImageEffectsClientFactory.create(details, requestInterceptors, this.httpClientInterceptorManager.responseInterceptors());
        });
    }

    private Optional<URI> buildServiceUri() {
        String clientUrl = this.config.getClientUrl();
        log.debug("Attempting to parse: {}", (Object)clientUrl);
        if (clientUrl == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(new URI(clientUrl));
        }
        catch (URISyntaxException ex) {
            log.warn("Unable to parse '{}', defaulting to in-memory transformations", (Object)clientUrl, (Object)ex);
            return Optional.empty();
        }
    }
}

