/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.resource;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSession;
import com.atlassian.confluence.extra.webdav.resource.AbstractPageExportContentResource;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.impl.ExportScope;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.log4j.Logger;

public class PagePdfExportContentResourceImpl
extends AbstractPageExportContentResource {
    public static final String CONTENT_TYPE = "application/pdf";
    public static final String DISPLAY_NAME_SUFFIX = ".pdf";
    private static final Logger LOGGER = Logger.getLogger(PagePdfExportContentResourceImpl.class);
    private final ImportExportManager importExportManager;

    public PagePdfExportContentResourceImpl(DavResourceLocator davResourceLocator, DavResourceFactory davResourceFactory, LockManager lockManager, ConfluenceDavSession davSession, @ComponentImport ImportExportManager importExportManager, @ComponentImport PageManager pageManager, String spaceKey, String pageTitle) {
        super(davResourceLocator, davResourceFactory, lockManager, davSession, pageManager, spaceKey, pageTitle);
        this.importExportManager = importExportManager;
    }

    @Override
    public boolean exists() {
        return super.exists() && !((ConfluenceDavSession)this.getSession()).getResourceStates().isContentPdfExportHidden((ContentEntityObject)this.getPage());
    }

    @Override
    protected String getExportSuffix() {
        return DISPLAY_NAME_SUFFIX;
    }

    private Object getPdfExporterService() {
        try {
            return ContainerManager.getComponent((String)"flyingPdfExporterService");
        }
        catch (ComponentNotFoundException cnfe) {
            LOGGER.debug((Object)"Unable to find PdfExporterService. Falling back to ImportExportManager for the export.", (Throwable)cnfe);
            return null;
        }
    }

    private File generatePdfExportFromPdfExporterService(Object pdfExporterService) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method exportMethod = pdfExporterService.getClass().getMethod("createPdfForPage", User.class, Page.class, String.class);
        return (File)exportMethod.invoke(pdfExporterService, AuthenticatedUserThreadLocal.get(), this.getPage(), ServletActionContext.getRequest().getContextPath());
    }

    private File generatePdfExportFromImportExportManager() throws ImportExportException {
        Page thisPage = this.getPage();
        DefaultExportContext context = new DefaultExportContext();
        context.setExportScope(ExportScope.PAGE);
        context.setType("TYPE_PDF");
        context.addWorkingEntity((ConfluenceEntityObject)thisPage);
        context.setExportComments(false);
        context.setExportAttachments(false);
        context.setExportHierarchy(false);
        context.setUser((User)AuthenticatedUserThreadLocal.get());
        ContentTree contentTree = new ContentTree();
        contentTree.addRootNode(new ContentNode(thisPage));
        context.setContentTree(contentTree);
        return new File(this.importExportManager.exportAs((ExportContext)context, new ProgressMeter()));
    }

    @Override
    protected InputStream getContentInternal() {
        try {
            Object pdfExporterService = this.getPdfExporterService();
            return new BufferedInputStream(new FileInputStream(null != pdfExporterService ? this.generatePdfExportFromPdfExporterService(pdfExporterService) : this.generatePdfExportFromImportExportManager()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error exporting " + this.getPage() + " as PDF. Returning InputStream with one byte"), (Throwable)e);
            return new ByteArrayInputStream(new byte[1]);
        }
    }

    @Override
    protected String getContentType() {
        return CONTENT_TYPE;
    }

    @Override
    public String getDisplayName() {
        return this.getPage().getTitle() + DISPLAY_NAME_SUFFIX;
    }
}

