/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.event;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class ThrottlingRejectedExecutionHandler
implements RejectedExecutionHandler {
    private final AtomicLong lastHandled = new AtomicLong(0L);
    private final RejectedExecutionHandler handler;
    private final long frequency;
    private final TimeUnit unit;

    ThrottlingRejectedExecutionHandler(RejectedExecutionHandler handler) {
        this(handler, 1L, TimeUnit.SECONDS);
    }

    ThrottlingRejectedExecutionHandler(RejectedExecutionHandler handler, long frequency, TimeUnit unit) {
        this.handler = handler;
        this.frequency = frequency;
        this.unit = unit;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = this.lastHandled.get()) <= this.unit.toMillis(this.frequency)) {
            return;
        }
        if (this.lastHandled.compareAndSet(last, now)) {
            this.handler.rejectedExecution(r, executor);
        }
    }
}

