/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public enum UsagePeriod {
    HOURLY("h|(?i:hour|hourly)", Hour.class),
    DAILY("d|(?i:day|daily)", Day.class),
    WEEKLY("w|(?i:week|weekly)", Week.class),
    MONTHLY("M|(?i:month|monthly)", Month.class),
    MINUTELY("m|(?i:minute|minutely)", Minute.class),
    QUARTERLY("q|(?i:quarter|quarterly)", Quarter.class),
    YEARLY("y|(?i:year|yearly)", Year.class);

    private final String regex;
    private final Class type;

    private UsagePeriod(String regex, Class type) {
        this.regex = regex;
        this.type = type;
    }

    public static UsagePeriod resolve(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return DAILY;
        }
        return Arrays.stream(UsagePeriod.values()).filter(period -> value.matches(period.regex)).findFirst().orElse(DAILY);
    }

    public Class getType() {
        return this.type;
    }
}

