package com.atlassian.confluence.ext.usage.index;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;

public class UserResult implements Comparable<UserResult> {

    private UserAccessor userManager;
    private String userName;
    private User user;

    public UserResult(String userName, UserAccessor userManager) {
        this.userManager = userManager;
        this.userName = userName;
    }

    public int getCount() {
        return count;
    }

    private int count;

    public void incrementCount() {
        count++;
    }

    public int compareTo(UserResult userResult) {
        if (userResult.count > count)
            return 1;
        else if (userResult.count < count)
            return -1;
        return 0;
    }

    public User getUser() {
        if (user == null)
            user = userManager.getUser(userName);

        return user;
    }

}
