package com.atlassian.confluence.ext.usage.event;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;

import java.util.Queue;

public class UsageTaskQueueAction extends ConfluenceActionSupport {
    private UsageTaskQueue taskQueue;
    private Queue<Runnable> queue;

    @Override
    public String execute() throws Exception {
        queue = taskQueue.getQueue();
        return super.execute();
    }

    public String flush() throws Exception {
        taskQueue.waitUntilQueueProcessed(1000L); // wait up to a second
        return execute();
    }

    @Override
    public boolean isPermitted() {
        return isPermittedInSuperClass() && permissionManager.hasPermission(getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    boolean isPermittedInSuperClass() {
        return super.isPermitted();
    }

    public void setUsageTaskQueue(UsageTaskQueue taskQueue) {
        this.taskQueue = taskQueue;
    }

    public Queue<Runnable> getQueue() {
        return queue;
    }
}
