/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.sandbox;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.SerializationUtils;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DocumentSerialisation {
    private static final DocumentBuilder documentBuilder = DocumentSerialisation.createDocumentBuilder();

    DocumentSerialisation() {
    }

    static byte[] serializeViaJava(Document document) {
        return SerializationUtils.serialize((Serializable)((Serializable)((Object)document)));
    }

    static Document deserializeViaJava(byte[] bytes) {
        return (Document)SerializationUtils.deserialize((byte[])bytes);
    }

    static byte[] serializeViaString(Document document) {
        DOMImplementationLS implementation = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = implementation.createLSSerializer();
        return serializer.writeToString(document).getBytes();
    }

    static Document deserializeViaString(byte[] bytes) {
        Document document;
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(new String(bytes)));
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        return document;
    }

    private static DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

