package com.atlassian.confluence.extra.flyingpdf.util;

import com.atlassian.annotations.Internal;
import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Pattern;

@Internal
public class UrlUtils {

    public static final Pattern pageDisplayUrlPattern = Pattern.compile("/display/([a-zA-Z0-9~]+)/([^/\\?]+)(\\?|\\z)");

    public static String getFullUrl(String baseUrl, String contextPath) {
        String url = baseUrl;
        if (StringUtils.isNotBlank(contextPath)) {
            int i = url.lastIndexOf(contextPath);
            if (i != -1) {
                url = url.substring(0, i);
            } else {
                url = "";
            }
        }
        return url;
    }

    public static String decodeTitle(String title) {
        if (title == null) {
            return null;
        }

        try {
            return URLDecoder.decode(title, "UTF8");
        } catch (UnsupportedEncodingException e) {
            // shouldn't happen.
            return title;
        }
    }

    public static String encodeTitle(String title) {
        if (title == null) {
            return null;
        }

        try {
            return URLEncoder.encode(title, "UTF8");
        } catch (UnsupportedEncodingException e) {
            // shouldn't happen.
            return title;
        }
    }
}
