package com.atlassian.confluence.extra.flyingpdf.util;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;

import java.io.File;
import java.io.IOException;

public class PdfUtils {

    public static int numberOfPages(File exportFile) {
        try {
            final String absolutePath = exportFile.getAbsolutePath();
            if (absolutePath == null) {
                // In case our clever unit tests mocked this file
                return -1;
            }
            // Try to get file size without loading entire file into memory
            final PdfReader reader = new PdfReader(new RandomAccessFileOrArray(absolutePath), null);
            final int size = reader.getNumberOfPages();
            reader.close();
            return size;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
