package com.atlassian.confluence.extra.flyingpdf.util;

import com.atlassian.confluence.importexport.impl.ConfluenceTempDirExportFileNameGenerator;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.setup.settings.ConfluenceDirectories;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;

@Component
public class PdfExporterTempDirFileNameGenerator implements ExportFileNameGenerator {

    private final ExportFileNameGenerator delegate;

    public PdfExporterTempDirFileNameGenerator(@ComponentImport ConfluenceDirectories confluenceDirectories) {
        this.delegate = ConfluenceTempDirExportFileNameGenerator.create(
                confluenceDirectories,
                "pdfexport", "pdf", "{0,date,yyyyMMdd}", "{1,time,ddMMyy-HHmm}");
    }

    @Override
    public File createExportDirectory() throws IOException {
        return delegate.createExportDirectory();
    }

    @Override
    public String getExportFileName(String... strings) {
        return delegate.getExportFileName(strings);
    }
}
