package com.atlassian.confluence.extra.flyingpdf.util;

import java.util.HashMap;

public class ImageInformationURICacheUtil {
    private final static ThreadLocal<HashMap<String, ImageInformation>> threadLocal = new ThreadLocal<>();

    /**
     * Initializes <code>HashMap</code> cache for current thread.
     */
    public static void initializeCache() {
        threadLocal.set(new HashMap<>());
    }

    /**
     * Removes <code>HashMap</code> for current thread.
     */
    public static void purgeCache() {
        threadLocal.remove();
    }

    public static ImageInformation getCacheURI(String uri) {
        HashMap<String, ImageInformation> cache = threadLocal.get();
        if (cache != null) {
            return cache.get(uri);
        }
        return null;
    }

    public static void setCacheURI(String uri, ImageInformation cacheValue) {
        HashMap<String, ImageInformation> cache = threadLocal.get();
        if (cache != null) {
            cache.put(uri, cacheValue);
        }
    }
}
