package com.atlassian.confluence.extra.flyingpdf.sandbox;

import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.util.sandbox.Sandbox;
import com.atlassian.confluence.util.sandbox.SandboxRegistry;
import com.atlassian.confluence.util.sandbox.SandboxSpec;
import com.atlassian.confluence.util.sandbox.SandboxTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.time.Duration;

/**
 * Sandbox for running PDF exports.
 */
@Component
class PdfExportSandbox {

    private Sandbox sandbox;
    private final SandboxRegistry sandboxRegistry;
    private final DownloadResourceManager downloadResourceManager;

    private static final int MEMORY_REQUIREMENT = Integer.getInteger("pdf.export.sandbox.memory.requirement.megabytes", 64);

    PdfExportSandbox(
            @ComponentImport SandboxRegistry sandboxRegistry,
            @ComponentImport DownloadResourceManager downloadResourceManager) {
        this.sandboxRegistry = sandboxRegistry;
        this.downloadResourceManager = downloadResourceManager;
    }

    /**
     * The ability to override time limit for PDF conversions
     */
    Duration requestTimeLimit() {
        return Duration.ofSeconds(Integer.getInteger("pdf.export.sandbox.request.time.limit.secs", 180));
    }

    @PostConstruct
    public void postConstruct() {
        sandbox = sandboxRegistry.get(SandboxSpec.builder()
                .withMinimumMemoryInMb(MEMORY_REQUIREMENT)
                .registerCallbackContextObject(DownloadResourceManager.class, downloadResourceManager)
                .build(requestTimeLimit()));
    }

    public <R, T> R execute(SandboxTask<T, R> task, T request) {
        return sandbox.execute(task, request);
    }


}
