package com.atlassian.confluence.extra.flyingpdf.sandbox;

import com.atlassian.confluence.util.sandbox.SandboxSerializer;

import java.util.ArrayList;
import java.util.List;

import static com.atlassian.confluence.util.sandbox.SandboxSerializers.compositeByteArraySerializer;
import static com.atlassian.confluence.util.sandbox.SandboxSerializers.stringSerializer;

public class GetResourceCallbackRequest {
    private final String uri;
    private final String username;

    public GetResourceCallbackRequest(String uri, String username) {
        this.uri = uri;
        this.username = username;
    }

    public String getUri() {
        return uri;
    }

    public String getUsername() {
        return username;
    }

    static Serializer serializer() {
        return Serializer.instance;
    }

    static class Serializer implements SandboxSerializer<GetResourceCallbackRequest> {
        static final Serializer instance = new Serializer();

        private Serializer() {
        }

        @Override
        public byte[] serialize(GetResourceCallbackRequest request) {
            List<byte[]> fields = new ArrayList<>();

            fields.add(stringSerializer().serialize(request.getUri()));
            fields.add(stringSerializer().serialize(request.getUsername()));

            return compositeByteArraySerializer().serialize(fields);
        }

        @Override
        public GetResourceCallbackRequest deserialize(byte[] bytes) {
            List<byte[]> fields = compositeByteArraySerializer().deserialize(bytes);
            return new GetResourceCallbackRequest(
                    stringSerializer().deserialize(fields.get(0)),
                    stringSerializer().deserialize(fields.get(1)));
        }
    }
}
